/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.settings.FromStrHelper;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.OptionsIOini;
import edu.uml.lgdc.project.settings.SectionDescriptor;
import edu.uml.lgdc.time.TimeScale;
import java.io.File;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class AppSettings {
    protected OptionsIO optionsIO;
    private final Map<String, SectionDescriptor<?>> allDescriptors;
    protected File file;
    protected boolean treatUnknownNamesAsError = true;
    protected boolean noIniFileAbsentMsg;
    private transient Map<String, SectionDescriptor<?>> thisDescriptors;
    private transient Set<String> duplicates;

    public AppSettings(String iniFileName) {
        this(iniFileName, false);
    }

    public AppSettings(String iniFileName, boolean noIniFileAbsentMsg) {
        this.createGroups();
        this.allDescriptors = this.getAllDescriptors();
        this.noIniFileAbsentMsg = noIniFileAbsentMsg;
        this.treatUnknownNamesAsError = true;
        this.read(iniFileName);
    }

    public AppSettings(InputStream inputStream) {
        this.createGroups();
        this.allDescriptors = this.getAllDescriptors();
        this.read(inputStream);
    }

    public void read(String iniFileName) {
        this.optionsIO = new OptionsIOini(this.allDescriptors, iniFileName, this.treatUnknownNamesAsError, this.noIniFileAbsentMsg);
        if (this.isError()) {
            throw new RuntimeException("There were errors in ini-file \"" + iniFileName + "\". See log-file for details");
        }
        this.file = ((OptionsIOini)this.optionsIO).getFile();
    }

    public void read(InputStream inputStream) {
        this.optionsIO = new OptionsIOini(this.allDescriptors, inputStream);
    }

    public void treatUnknownNamesAsError(boolean treatUnknownNamesAsError) {
        this.treatUnknownNamesAsError = treatUnknownNamesAsError;
    }

    public void setNoIniFileAbsentMsg(boolean noIniFileAbsentMsg) {
        this.noIniFileAbsentMsg = noIniFileAbsentMsg;
    }

    public File getFile() {
        return this.file;
    }

    public OptionsIO getOptionsIO() {
        return this.optionsIO;
    }

    public boolean isError() {
        return this.optionsIO.isError() || this.isParsingOrIllegalValueError();
    }

    private boolean isParsingOrIllegalValueError() {
        boolean error = false;
        for (SectionDescriptor<?> pasrSecDescriptor : this.allDescriptors.values()) {
            if (!pasrSecDescriptor.isParsingOrIllegalValueError()) continue;
            error = true;
        }
        return error;
    }

    private void createGroups() {
        this.thisDescriptors = new HashMap();
        this.duplicates = new HashSet<String>();
        this.createCustomGroups();
        if (this.duplicates.size() > 0) {
            throw new RuntimeException("Design error: duplicated settings groups, " + Arrays.toString(this.duplicates.toArray()));
        }
        this.duplicates = null;
    }

    protected abstract void createCustomGroups();

    private Map<String, SectionDescriptor<?>> getAllDescriptors() {
        if (this.allDescriptors != null) {
            return this.allDescriptors;
        }
        HashMap allDescriptors = new HashMap();
        this.addAllDescriptors(allDescriptors);
        return allDescriptors;
    }

    protected abstract void addAllDescriptors(Map<String, SectionDescriptor<?>> var1);

    protected SectionDescriptor<?> checkDescriptors(SectionDescriptor<?> descriptor) {
        if (this.thisDescriptors.put(descriptor.getName(), descriptor) != null) {
            this.duplicates.add(descriptor.getName());
        }
        return descriptor;
    }

    public static boolean getBoolean(OptionsIO optionsIO, String sectionName, String optionName, boolean deflt) throws IllegalArgumentException {
        FromStrHelper.Result result = FromStrHelper.getBoolean(optionsIO.get(sectionName, optionName), deflt);
        if (result.errMsg == null) {
            return (Boolean)result.value;
        }
        throw new IllegalArgumentException("Section [" + sectionName + "] options " + optionName + ": " + result.errMsg);
    }

    public static TimeScale getTimestampFromString(String value, String timeFormat) {
        try {
            if (value.trim().length() > 0) {
                return TimeScale.getTimestampFromString(value, timeFormat);
            }
            return null;
        }
        catch (ParseException ex) {
            Console.printThreadStackTrace(ex);
            return null;
        }
    }
}

