/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

import edu.uml.lgdc.fileio.FileRW;
import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.project.CommonConst;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.Version;
import edu.uml.lgdc.project.settings.StrictProperties;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Objects;

public class ApplicationProperties
extends StrictProperties {
    private static final String MSG_FAILURE = "can't load property file ";
    private final String filename;
    private final String applicationName;
    private FileInputStream inStream;
    private FileOutputStream outStream;
    private String appNameFromFile;
    private Version appVersionFromFile;

    public ApplicationProperties(String filename, String appName) {
        this.applicationName = appName;
        int lastSepPos = filename.lastIndexOf(File.separatorChar);
        this.filename = lastSepPos == -1 ? new File(CommonConst.getWorkingDir(), filename).getPath() : filename;
    }

    public void load() {
        this.loadFromFile(this.filename);
    }

    public void save() {
        this.saveToFile(this.filename);
    }

    public boolean loadFromFile(String filename) {
        return this.loadFromFile(filename, false);
    }

    public boolean loadFromFile(String filename, boolean doNotReportNonExistense) {
        boolean ioError;
        boolean result;
        block27: {
            Objects.requireNonNull(filename);
            result = false;
            ioError = false;
            this.inStream = null;
            File file = new File(filename);
            if (file.exists() && file.length() == 0L) {
                file.delete();
            }
            if (!file.exists()) {
                if (!doNotReportNonExistense) {
                    Console.showWarn("ini-file " + filename + " does not exist");
                }
                return false;
            }
            try {
                this.readApplicationNameAndVersion(filename);
                this.inStream = new FileInputStream(filename);
                this.load(this.inStream);
                this.inStream.close();
                result = true;
            }
            catch (FileNotFoundException ex) {
                if (new File(filename).exists()) {
                    Console.showError(ex.toString());
                    ioError = true;
                } else if (!doNotReportNonExistense) {
                    Console.showWarn(ex.toString());
                }
                if (this.inStream != null) {
                    try {
                        this.inStream.close();
                    }
                    catch (IOException e) {
                        Console.printThreadStackTrace(e);
                    }
                }
                break block27;
            }
            catch (IOException ex) {
                try {
                    Console.showError(ex.toString());
                    ioError = true;
                    break block27;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (this.inStream != null) {
                        try {
                            this.inStream.close();
                        }
                        catch (IOException e) {
                            Console.printThreadStackTrace(e);
                        }
                    }
                }
            }
            if (this.inStream == null) break block27;
            try {
                this.inStream.close();
            }
            catch (IOException e) {
                Console.printThreadStackTrace(e);
            }
        }
        if (!result) {
            if (!ioError) {
                if (!doNotReportNonExistense) {
                    Console.showWarn(MSG_FAILURE + filename);
                }
            } else {
                Console.showError(MSG_FAILURE + filename);
            }
        }
        return result;
    }

    public boolean saveToFile(String filename) {
        boolean result;
        block12: {
            result = false;
            this.outStream = null;
            FileDescriptor fd = null;
            try {
                try {
                    File file = new File(filename);
                    file.delete();
                    this.outStream = new FileOutputStream(file);
                    fd = this.outStream.getFD();
                    this.store(this.outStream, "(c) UMLCAR, Application Properties File, v 1.0, Application: " + this.applicationName);
                    this.outStream.flush();
                    fd.sync();
                    this.outStream.close();
                    this.outStream = null;
                    result = true;
                }
                catch (IOException ex) {
                    Console.printThreadStackTrace(ex);
                    Console.showError("can't save property file " + filename);
                    if (this.outStream == null) break block12;
                    try {
                        this.outStream.close();
                    }
                    catch (IOException ex2) {
                        Console.printThreadStackTrace(ex2);
                    }
                }
            }
            finally {
                if (this.outStream != null) {
                    try {
                        this.outStream.close();
                    }
                    catch (IOException ex) {
                        Console.printThreadStackTrace(ex);
                    }
                }
            }
        }
        return result;
    }

    public String getAppNameFromFile() {
        return this.appNameFromFile;
    }

    public Version getAppVersionFromFile() {
        return this.appVersionFromFile;
    }

    private void readApplicationNameAndVersion(String filename) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileRW fileRW = new FileRW(filename, "r");){
            String line = fileRW.readLine();
            if (line == null) {
            } else if ((line = line.trim()).length() != 0) {
                if (line.charAt(0) != '#') {
                } else {
                    this.setAppNameAndVersion(line);
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private void setAppNameAndVersion(String line) {
        int ind;
        String appName = null;
        Version appVersion = null;
        String[] words = StrUtil.listToArray(line, ' ');
        if (words.length >= 4 && (ind = Search.scanStr(words, "Application:")) >= 0 && ind != words.length - 1) {
            appName = words[++ind];
            if (!(ind == words.length - 1 || words[++ind].equals("v") && ind++ == words.length - 1)) {
                appVersion = this.getVersion(words[ind]);
            }
        }
        this.appNameFromFile = appName;
        this.appVersionFromFile = appVersion;
    }

    private Version getVersion(String str) {
        Version version = null;
        if (str.length() != 0) {
            if (str.charAt(0) == 'v') {
                str = str.substring(1);
            }
            if (str.length() != 0) {
                version = Version.getVersion(str);
            }
        }
        return version;
    }
}

