/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

import edu.uml.lgdc.project.ChosenFileDir;
import edu.uml.lgdc.project.settings.ContentType;
import edu.uml.lgdc.project.settings.OptionDesc;
import edu.uml.lgdc.project.settings.OptionsIO;
import edu.uml.lgdc.project.settings.SectionDescriptor;
import java.util.HashMap;
import java.util.Map;

public class OpenFileSettings
extends SectionDescriptor<OpenFileSettings>
implements ChosenFileDir {
    public static final String SECTION_NAME = "Open File";
    private static final String OPTION_FILE_NAME = "FileName";
    private static final String OPTION_DIR_NAME = "DirName";
    private String filename;
    private String dirname;
    private final Map<String, OptionDesc> descriptor = new HashMap<String, OptionDesc>();

    public OpenFileSettings() {
        this.setDefaults();
        this.fillDescriptor();
    }

    public void setDefaults() {
        this.filename = null;
        this.dirname = null;
    }

    @Override
    public OpenFileSettings getThis() {
        return this;
    }

    @Override
    public String getName() {
        return SECTION_NAME;
    }

    @Override
    public Map<String, OptionDesc> getOptionsDescriptor() {
        return this.descriptor;
    }

    @Override
    public String[] optionRenameHook(String unknowmParamName, String valueOfUnknownParamName) {
        switch (unknowmParamName) {
            case "fileName": {
                return new String[]{OPTION_FILE_NAME, valueOfUnknownParamName};
            }
            case "dirName": {
                return new String[]{OPTION_DIR_NAME, valueOfUnknownParamName};
            }
        }
        return null;
    }

    @Override
    protected void fillDescriptor() {
        this.descriptor.put(OPTION_FILE_NAME, new OptionDesc((Object)this.filename, ContentType.MISC));
        this.descriptor.put(OPTION_DIR_NAME, new OptionDesc((Object)this.dirname, ContentType.MISC));
    }

    @Override
    public void getFrom(OptionsIO paramsIO) {
        this.filename = paramsIO.get(SECTION_NAME, OPTION_FILE_NAME);
        this.dirname = paramsIO.get(SECTION_NAME, OPTION_DIR_NAME);
    }

    @Override
    public void putTo(OptionsIO paramsIO) {
        paramsIO.put(SECTION_NAME, OPTION_FILE_NAME, this.filename);
        paramsIO.put(SECTION_NAME, OPTION_DIR_NAME, this.dirname);
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getDirname() {
        return this.dirname;
    }

    public void setDirname(String dirName) {
        this.dirname = dirName;
    }

    @Override
    public String getChosenFilename() {
        return this.getFilename();
    }

    @Override
    public void setChosenFilename(String filename) {
        this.setFilename(filename);
    }

    @Override
    public String getChosenDirname() {
        return this.getDirname();
    }

    @Override
    public void setChosenDirname(String dirname) {
        this.setDirname(dirname);
    }
}

