/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

import edu.uml.lgdc.math.Search;
import java.util.ArrayList;
import java.util.List;

public class StrParams
implements Cloneable {
    private List<Param> params = new ArrayList<Param>(16);

    public StrParams() {
    }

    public StrParams(String[][] params) {
        this.add(params);
    }

    public StrParams(Param[] params) {
        this.add(params);
    }

    public void add(String[][] params) {
        if (params == null) {
            return;
        }
        int i = 0;
        while (i < params.length) {
            this.add(params[i]);
            ++i;
        }
    }

    public void add(Param[] params) {
        if (params == null) {
            return;
        }
        int i = 0;
        while (i < params.length) {
            this.add(params[i]);
            ++i;
        }
    }

    public void add(String[] param) {
        if (param == null) {
            return;
        }
        if (param.length != 2) {
            throw new IllegalArgumentException("param.length should be = 2, but is " + param.length);
        }
        this.add(new Param(param[0], param[1]));
    }

    public void add(Param param) {
        if (param == null) {
            return;
        }
        int index = Search.leftNearest(this.params, param);
        if (index < 0) {
            this.params.add(0, param);
        } else if (this.params.get(index).compareTo(param) != 0) {
            this.params.add(index + 1, param);
        } else {
            throw new RuntimeException("parameter " + param.name + " has been already added");
        }
    }

    public String[] getParamPair(String name) {
        Param param = this.getParam(name);
        if (param != null) {
            return new String[]{param.name, param.value};
        }
        return null;
    }

    public Param getParam(String name) {
        int index = Search.binarySearch(this.params, new Param(name, null));
        if (index >= 0) {
            return this.params.get(index);
        }
        return null;
    }

    public String[][] getParamsAsStrArr() {
        String[][] arrParams = new String[this.params.size()][2];
        int i = 0;
        while (i < arrParams.length) {
            arrParams[i][0] = this.params.get(i).name;
            arrParams[i][1] = this.params.get(i).value;
            ++i;
        }
        return arrParams;
    }

    public Object clone() {
        StrParams strParams;
        try {
            strParams = (StrParams)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
        int size = this.params.size();
        strParams.params = new ArrayList<Param>(size);
        int i = 0;
        while (i < size) {
            strParams.add((Param)this.params.get(i).clone());
            ++i;
        }
        return strParams;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof StrParams)) {
            return false;
        }
        StrParams strParams = (StrParams)obj;
        if (this.params.size() != strParams.params.size()) {
            return false;
        }
        int size = this.params.size();
        int i = 0;
        while (i < size) {
            if (!this.params.get(i).equals(strParams.params.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static class Param
    implements Comparable<Param>,
    Cloneable {
        private final String name;
        private String value;

        public Param(String name, String value) {
            if (name == null) {
                throw new IllegalArgumentException("name is null");
            }
            this.name = name;
            this.value = value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        @Override
        public int compareTo(Param param) {
            if (param == null) {
                return 1;
            }
            return this.name.compareTo(param.name);
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof Param)) {
                return false;
            }
            Param par = (Param)obj;
            if (!this.name.equals(par.name)) {
                return false;
            }
            if (this.value == null) {
                return par.value == null;
            }
            return this.value.equals(par.value);
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }
}

