/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.project.settings;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.project.Portable;
import edu.uml.lgdc.time.TimeScale;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;

public class StrictProperties
extends Properties {
    public void loadFromGeneric(String propertiesString) {
        propertiesString = propertiesString.trim();
        propertiesString = propertiesString.substring(1, propertiesString.length() - 1);
        String[] strArray = StrUtil.listToArray(propertiesString, ',');
        StringBuffer text = new StringBuffer(500);
        int i = 0;
        while (i < strArray.length) {
            text.append(strArray[i]);
            text.append("\n");
            ++i;
        }
        this.load(text.toString());
    }

    public void load(String propertiesString) {
        ByteArrayInputStream inStream = new ByteArrayInputStream(propertiesString.getBytes());
        this.clear();
        this.loadWithoutEx(inStream);
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        super.load(inStream);
    }

    public boolean loadWithoutEx(InputStream inStream) {
        boolean ok = false;
        try {
            super.load(inStream);
            ok = true;
        }
        catch (IOException ex) {
            Console.showError(ex.toString());
            Console.showError("can't load properties");
        }
        return ok;
    }

    public String getPropertiesString() {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(512);
        try {
            this.store(outStream, null);
        }
        catch (IOException ex) {
            Console.showError(ex.toString());
            Console.showError("can't get properties as a String");
        }
        return outStream.toString();
    }

    public String get(String key, String defaultValue) {
        String retValue = super.getProperty(key);
        if (retValue == null) {
            retValue = defaultValue;
        }
        return retValue;
    }

    public Portable get(String key, Portable defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue == null");
        }
        String retValue = super.getProperty(key);
        if (retValue != null) {
            defaultValue.setPortable(retValue.trim());
        }
        return defaultValue;
    }

    public long get(String key, long defaultValue) {
        String retValue = super.getProperty(key);
        if (retValue != null) {
            return FC.StringToLong(retValue, 0, defaultValue);
        }
        return defaultValue;
    }

    public int get(String key, int defaultValue) {
        return (int)this.get(key, (long)defaultValue);
    }

    public short get(String key, short defaultValue) {
        return (short)this.get(key, (long)defaultValue);
    }

    public char get(String key, char defaultValue) {
        String retValue = super.getProperty(key);
        if (retValue != null && retValue.length() > 0) {
            return retValue.charAt(0);
        }
        return defaultValue;
    }

    public double get(String key, double defaultValue) {
        String retValue = super.getProperty(key);
        if (retValue != null) {
            return FC.StringToDouble(retValue, 0, defaultValue);
        }
        return defaultValue;
    }

    public float get(String key, float defaultValue) {
        return (float)this.get(key, (double)defaultValue);
    }

    public boolean get(String key, boolean defaultValue) {
        String retValue = super.getProperty(key);
        if (retValue != null) {
            return Boolean.valueOf(retValue);
        }
        return defaultValue;
    }

    public Boolean get(String key, Boolean defaultValue) {
        String retValue = super.getProperty(key);
        if (retValue != null) {
            return Boolean.valueOf(retValue);
        }
        return defaultValue;
    }

    public TimeScale get(String key, TimeScale defaultValue) {
        String retValue = super.getProperty(key);
        if (retValue != null) {
            return new TimeScale(retValue);
        }
        return defaultValue;
    }

    public Color get(String key, Color defaultValue) {
        String retValue = super.getProperty(key);
        if (retValue != null) {
            return new Color(FC.StringToInteger(retValue, 0));
        }
        return defaultValue;
    }

    public boolean[] getFixedArray(String key, boolean[] defaultValue) {
        boolean[] retValue = new boolean[defaultValue.length];
        int i = 0;
        while (i < defaultValue.length) {
            retValue[i] = this.get(StrictProperties.arrayKey(key, i), defaultValue[i]);
            ++i;
        }
        return retValue;
    }

    public boolean[] get(String key, boolean[] defaultValue) {
        return this.get(key, defaultValue, -1);
    }

    public boolean[] get(String key, boolean[] defaultValue, int maxDim) {
        boolean[] retValue = null;
        int dim = this.getArrayKeyDimension(key);
        if (dim <= 0) {
            retValue = defaultValue == null ? new boolean[]{} : (boolean[])defaultValue.clone();
        } else {
            if (maxDim >= 0) {
                dim = Math.min(dim, maxDim);
            }
            retValue = new boolean[dim];
            int i = 0;
            while (i < dim) {
                retValue[i] = this.get(StrictProperties.arrayKey(key, i), (Boolean)null);
                ++i;
            }
        }
        return retValue;
    }

    public Boolean[] getFixedArray(String key, Boolean[] defaultValue) {
        Boolean[] retValue = new Boolean[defaultValue.length];
        int i = 0;
        while (i < defaultValue.length) {
            retValue[i] = this.get(StrictProperties.arrayKey(key, i), defaultValue[i]);
            ++i;
        }
        return retValue;
    }

    public Boolean[] get(String key, Boolean[] defaultValue) {
        return this.get(key, defaultValue, -1);
    }

    public Boolean[] get(String key, Boolean[] defaultValue, int maxDim) {
        Boolean[] retValue = null;
        int dim = this.getArrayKeyDimension(key);
        if (dim <= 0) {
            retValue = defaultValue == null ? new Boolean[]{} : (Boolean[])defaultValue.clone();
        } else {
            if (maxDim >= 0) {
                dim = Math.min(dim, maxDim);
            }
            retValue = new Boolean[dim];
            int i = 0;
            while (i < dim) {
                retValue[i] = this.get(StrictProperties.arrayKey(key, i), (Boolean)null);
                ++i;
            }
        }
        return retValue;
    }

    public Color[] getFixedArray(String key, Color[] defaultValue) {
        Color[] retValue = new Color[defaultValue.length];
        int i = 0;
        while (i < defaultValue.length) {
            retValue[i] = this.get(StrictProperties.arrayKey(key, i), defaultValue[i]);
            ++i;
        }
        return retValue;
    }

    public Color[] get(String key, Color[] defaultValue) {
        return this.get(key, defaultValue, -1);
    }

    public Color[] get(String key, Color[] defaultValue, int maxDim) {
        Color[] retValue = null;
        int dim = this.getArrayKeyDimension(key);
        if (dim <= 0) {
            retValue = defaultValue == null ? new Color[]{} : (Color[])defaultValue.clone();
        } else {
            if (maxDim >= 0) {
                dim = Math.min(dim, maxDim);
            }
            retValue = new Color[dim];
            int i = 0;
            while (i < dim) {
                retValue[i] = this.get(StrictProperties.arrayKey(key, i), (Color)null);
                ++i;
            }
        }
        return retValue;
    }

    public int[] getFixedArray(String key, int[] defaultValue) {
        int[] retValue = new int[defaultValue.length];
        int i = 0;
        while (i < defaultValue.length) {
            retValue[i] = this.get(StrictProperties.arrayKey(key, i), defaultValue[i]);
            ++i;
        }
        return retValue;
    }

    public int[] get(String key, int[] defaultValue) {
        return this.get(key, defaultValue, -1);
    }

    public int[] get(String key, int[] defaultValue, int maxDim) {
        int[] retValue = null;
        int dim = this.getArrayKeyDimension(key);
        if (dim <= 0) {
            retValue = defaultValue == null ? new int[]{} : (int[])defaultValue.clone();
        } else {
            if (maxDim >= 0) {
                dim = Math.min(dim, maxDim);
            }
            retValue = new int[dim];
            int i = 0;
            while (i < dim) {
                retValue[i] = this.get(StrictProperties.arrayKey(key, i), 0);
                ++i;
            }
        }
        return retValue;
    }

    public String[] getFixedArray(String key, String[] defaultValue) {
        String[] retValue = new String[defaultValue.length];
        int i = 0;
        while (i < defaultValue.length) {
            retValue[i] = this.get(StrictProperties.arrayKey(key, i), defaultValue[i]);
            ++i;
        }
        return retValue;
    }

    public String[] get(String key, String[] defaultValue) {
        return this.get(key, defaultValue, -1);
    }

    public String[] get(String key, String[] defaultValue, int maxDim) {
        String[] retValue = null;
        int dim = this.getArrayKeyDimension(key);
        if (dim <= 0) {
            retValue = defaultValue == null ? new String[]{} : (String[])defaultValue.clone();
        } else {
            if (maxDim >= 0) {
                dim = Math.min(dim, maxDim);
            }
            retValue = new String[dim];
            int i = 0;
            while (i < dim) {
                retValue[i] = this.get(StrictProperties.arrayKey(key, i), (String)null);
                ++i;
            }
        }
        return retValue;
    }

    public double[] getFixedArray(String key, double[] defaultValue) {
        double[] retValue = new double[defaultValue.length];
        int i = 0;
        while (i < defaultValue.length) {
            retValue[i] = this.get(StrictProperties.arrayKey(key, i), defaultValue[i]);
            ++i;
        }
        return retValue;
    }

    public double[] get(String key, double[] defaultValue) {
        return this.get(key, defaultValue, -1);
    }

    public double[] get(String key, double[] defaultValue, int maxDim) {
        double[] retValue = null;
        int dim = this.getArrayKeyDimension(key);
        if (dim <= 0) {
            retValue = defaultValue == null ? new double[]{} : (double[])defaultValue.clone();
        } else {
            if (maxDim >= 0) {
                dim = Math.min(dim, maxDim);
            }
            retValue = new double[dim];
            int i = 0;
            while (i < dim) {
                retValue[i] = this.get(StrictProperties.arrayKey(key, i), 0.0);
                ++i;
            }
        }
        return retValue;
    }

    @Override
    public void put(String key, String value) {
        if (value != null) {
            this.put((Object)key, (Object)value);
        } else {
            this.remove(key);
        }
    }

    @Override
    public void put(String key, Portable value) {
        if (value != null) {
            this.put((Object)key, (Object)value.getPortable());
        } else {
            this.remove(key);
        }
    }

    @Override
    public void put(String key, long value) {
        this.put(key, new Long(value).toString());
    }

    @Override
    public void put(String key, char value) {
        this.put(key, Character.toString(value));
    }

    @Override
    public void put(String key, int value) {
        this.put(key, (long)value);
    }

    @Override
    public void put(String key, short value) {
        this.put(key, (long)value);
    }

    @Override
    public void put(String key, double value) {
        this.put(key, new Double(value).toString());
    }

    @Override
    public void put(String key, float value) {
        this.put(key, (double)value);
    }

    @Override
    public void put(String key, boolean value) {
        this.put(key, new Boolean(value));
    }

    @Override
    public void put(String key, Object value) {
        if (value != null) {
            this.put((Object)key, value);
        } else {
            this.remove(key);
        }
    }

    @Override
    public void put(String key, Boolean value) {
        if (value != null) {
            this.put(key, value.toString());
        } else {
            this.remove(key);
        }
    }

    @Override
    public void put(String key, TimeScale value) {
        if (value != null) {
            this.put(key, value.toShortUT());
        } else {
            this.remove(key);
        }
    }

    @Override
    public void put(String key, Color value) {
        if (value != null) {
            this.put(key, value.getRGB());
        } else {
            this.remove(key);
        }
    }

    @Override
    public void put(String key, Boolean[] value) {
        if (value != null) {
            int i;
            int dim = this.getArrayKeyDimension(key);
            if (dim > value.length) {
                i = value.length;
                while (i < dim) {
                    this.remove(StrictProperties.arrayKey(key, i));
                    ++i;
                }
            }
            i = 0;
            while (i < value.length) {
                this.put(StrictProperties.arrayKey(key, i), value[i]);
                ++i;
            }
        } else {
            this.removeArray(key);
        }
    }

    @Override
    public void put(String key, boolean[] value) {
        if (value != null) {
            int i;
            int dim = this.getArrayKeyDimension(key);
            if (dim > value.length) {
                i = value.length;
                while (i < dim) {
                    this.remove(StrictProperties.arrayKey(key, i));
                    ++i;
                }
            }
            i = 0;
            while (i < value.length) {
                this.put(StrictProperties.arrayKey(key, i), value[i]);
                ++i;
            }
        } else {
            this.removeArray(key);
        }
    }

    @Override
    public void put(String key, int[] value) {
        if (value != null) {
            int i;
            int dim = this.getArrayKeyDimension(key);
            if (dim > value.length) {
                i = value.length;
                while (i < dim) {
                    this.remove(StrictProperties.arrayKey(key, i));
                    ++i;
                }
            }
            i = 0;
            while (i < value.length) {
                this.put(StrictProperties.arrayKey(key, i), value[i]);
                ++i;
            }
        } else {
            this.removeArray(key);
        }
    }

    @Override
    public void put(String key, Color[] value) {
        if (value != null) {
            int i;
            int dim = this.getArrayKeyDimension(key);
            if (dim > value.length) {
                i = value.length;
                while (i < dim) {
                    this.remove(StrictProperties.arrayKey(key, i));
                    ++i;
                }
            }
            i = 0;
            while (i < value.length) {
                this.put(StrictProperties.arrayKey(key, i), value[i]);
                ++i;
            }
        } else {
            this.removeArray(key);
        }
    }

    @Override
    public void put(String key, String[] value) {
        if (value != null) {
            int i;
            int dim = this.getArrayKeyDimension(key);
            if (dim > value.length) {
                i = value.length;
                while (i < dim) {
                    this.remove(StrictProperties.arrayKey(key, i));
                    ++i;
                }
            }
            i = 0;
            while (i < value.length) {
                this.put(StrictProperties.arrayKey(key, i), value[i]);
                ++i;
            }
        } else {
            this.removeArray(key);
        }
    }

    @Override
    public void put(String key, double[] value) {
        if (value != null) {
            int i;
            int dim = this.getArrayKeyDimension(key);
            if (dim > value.length) {
                i = value.length;
                while (i < dim) {
                    this.remove(StrictProperties.arrayKey(key, i));
                    ++i;
                }
            }
            i = 0;
            while (i < value.length) {
                this.put(StrictProperties.arrayKey(key, i), value[i]);
                ++i;
            }
        } else {
            this.removeArray(key);
        }
    }

    public boolean isKeyExists(String key) {
        return this.containsKey(key);
    }

    public boolean isArrayKeyExists(String key) {
        return this.containsKey(StrictProperties.arrayKey(key, 0));
    }

    public int getArrayKeyDimension(String key) {
        int maxIndex = -1;
        boolean keyIsFound = false;
        Enumeration<?> ptyNames = this.propertyNames();
        while (ptyNames.hasMoreElements()) {
            String strNextKey;
            Object nextKey = ptyNames.nextElement();
            if (key.equals(nextKey)) {
                keyIsFound = true;
                continue;
            }
            if (!(nextKey instanceof String) || !(strNextKey = (String)nextKey).startsWith(String.valueOf(key) + "[")) continue;
            maxIndex = Math.max(maxIndex, FC.StringToInteger(strNextKey.substring(key.length() + 1, strNextKey.length() - 1)));
        }
        if (maxIndex >= 0 || keyIsFound) {
            ++maxIndex;
        }
        return maxIndex;
    }

    public void removeArray(String key) {
        int dim = this.getArrayKeyDimension(key);
        int i = 0;
        while (i < dim) {
            this.remove(StrictProperties.arrayKey(key, i));
            ++i;
        }
    }

    private static String arrayKey(String key, int i) {
        return String.valueOf(key) + "[" + i + "]";
    }
}

