/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.quantities;

import edu.uml.lgdc.quantities.Units;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class MeasureCat {
    private static final String PATH;
    private static final Map<String, MeasureCat> regCategories;
    private final Map<String, Units> regUnits = new HashMap<String, Units>(20, 0.5f);
    private final String name;
    private final String unitsName;

    static {
        String className = MeasureCat.class.getName();
        PATH = className.substring(1, className.lastIndexOf(46));
        regCategories = new HashMap<String, MeasureCat>(64, 0.5f);
        MeasureCat.registerAllCategories();
    }

    protected MeasureCat(String name, String unitsName) {
        if (name == null || unitsName == null) {
            throw new IllegalArgumentException("MeasureCat constructor: null parameters");
        }
        if (regCategories.containsKey(name)) {
            throw new IllegalArgumentException("MeasureCat constructor: category " + name + " already registedred");
        }
        for (MeasureCat cat : regCategories.values()) {
            if (!cat.getUnitsName().equals(unitsName)) continue;
            throw new IllegalArgumentException("MeasureCat constructor: the same unitsName (" + unitsName + ") already indicated for category (" + cat.getName() + ")");
        }
        this.name = name;
        this.unitsName = unitsName;
        regCategories.put(name, this);
    }

    public String getName() {
        return this.name;
    }

    public String getUnitsName() {
        return this.unitsName;
    }

    public Units getUnits(String unitsName) {
        return this.regUnits.get(unitsName);
    }

    static void registerUnits(Units units) {
        Units u = MeasureCat.getUnitsFromTable(units.getName());
        if (u != null) {
            throw new IllegalArgumentException("MeasureCat: units " + units.getName() + " is already registedred " + " for category  (" + u.getCategory().getName() + ")");
        }
        units.getCategory().regUnits.put(units.getName(), units);
    }

    public static MeasureCat getTime() {
        return MeasureCat.getCategory("Time", "sec");
    }

    public static MeasureCat getMass() {
        return MeasureCat.getCategory("Mass", "kg");
    }

    public static MeasureCat getLength() {
        return MeasureCat.getCategory("Length", "m");
    }

    public static MeasureCat getElectricCurrent() {
        return MeasureCat.getCategory("Electric Current", "A");
    }

    public static MeasureCat getTemperature() {
        return MeasureCat.getCategory("Temperature", "K");
    }

    public static MeasureCat getForce() {
        return MeasureCat.getCategory("Force", "N");
    }

    public static MeasureCat getEnergy() {
        return MeasureCat.getCategory("Energy", "J");
    }

    public static MeasureCat getPower() {
        return MeasureCat.getCategory("Power", "W");
    }

    public static MeasureCat getElectricPotential() {
        return MeasureCat.getCategory("Electric Potential", "V");
    }

    public static MeasureCat getElectricCharge() {
        return MeasureCat.getCategory("Electric Charge", "C");
    }

    public static MeasureCat getFrequency() {
        return MeasureCat.getCategory("Frequency", "Hz");
    }

    public static MeasureCat getLogRatio() {
        return MeasureCat.getCategory("LogRatio", "dB");
    }

    public static MeasureCat getAngle() {
        return MeasureCat.getCategory("Angle", "deg");
    }

    public static MeasureCat getCount() {
        return MeasureCat.getCategory("Count", "");
    }

    private static final MeasureCat getCategory(String catName, String unitsName) {
        MeasureCat category = MeasureCat.getCategory(catName);
        if (category == null) {
            category = new MeasureCat(catName, unitsName);
        } else if (!category.getUnitsName().equals(unitsName)) {
            throw new IllegalArgumentException("MeasureCat constructor: category " + catName + " already registedred with different unitsName (" + category.getUnitsName() + ")");
        }
        return category;
    }

    private static void registerAllCategories() {
        MeasureCat.getTime();
        MeasureCat.getMass();
        MeasureCat.getLength();
        MeasureCat.getElectricCurrent();
        MeasureCat.getTemperature();
        MeasureCat.getForce();
        MeasureCat.getEnergy();
        MeasureCat.getPower();
        MeasureCat.getElectricPotential();
        MeasureCat.getElectricCharge();
        MeasureCat.getFrequency();
        MeasureCat.getLogRatio();
        MeasureCat.getAngle();
        MeasureCat.getCount();
    }

    public static MeasureCat getCategory(String name) {
        return regCategories.get(name);
    }

    public static Units getUnitsByName(String name) {
        try {
            Class<?> classUnits = Class.forName(String.valueOf(PATH) + ".Quantities.U_" + name);
            Method method = classUnits.getMethod("get", new Class[0]);
            return (Units)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            System.err.println(e.toString());
            return null;
        }
    }

    private static Units getUnitsFromTable(String name) {
        for (MeasureCat cat : regCategories.values()) {
            Units u = cat.regUnits.get(name);
            if (u == null) continue;
            return u;
        }
        return null;
    }
}

