/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.quantities;

import edu.uml.lgdc.datatype.LinearVectorSpace;
import edu.uml.lgdc.quantities.Units;

public class Qy<T extends Units>
implements LinearVectorSpace<Qy<T>> {
    private static final double SMALL = 1.0E-7;
    protected double value;
    protected T units;

    protected Qy(double value, T units) {
        this.value = value;
        this.units = units;
    }

    public double get(Units out) {
        return Qy.convert(this.value, this.units, out);
    }

    public Qy<T> put(Qy<T> quantity) {
        return this.put(quantity.value, quantity.units);
    }

    @Override
    public void zero() {
        this.value = 0.0;
    }

    @Override
    public final void add(Qy<T> quantity) {
        this.add(quantity.value, (Units)quantity.units);
    }

    public final void sub(Qy<T> quantity) {
        this.sub(quantity.value, (Units)quantity.units);
    }

    @Override
    public void scalar(double scalar) {
        this.value *= scalar;
    }

    public Qy<T> put(double value, T in) {
        this.value = Qy.convert(value, in, this.units);
        return this;
    }

    public <U extends Units> Qy<T> add(double value, U in) {
        this.value += Qy.convert(value, in, this.units);
        return this;
    }

    public <U extends Units> Qy<T> sub(double value, U in) {
        this.value -= Qy.convert(value, in, this.units);
        return this;
    }

    private static <U extends Units, V extends Units> double convert(double value, U in, V out) {
        if (in.getCategory() != out.getCategory()) {
            throw new IllegalArgumentException("Quantity.convert: incompatible units");
        }
        if (in != out) {
            double rintValue;
            if ((value *= out.getFactor() / in.getFactor()) > (rintValue = Math.rint(value)) - 1.0E-7 && value < rintValue) {
                return rintValue;
            }
            return value;
        }
        return value;
    }

    public T getUnits() {
        return this.units;
    }

    public double getValue() {
        return this.value;
    }

    public String getName() {
        return ((Units)this.units).getName();
    }
}

