/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.radio;

import edu.uml.lgdc.radio.Polarization;
import java.util.HashMap;
import java.util.Map;

public enum Polarizations {
    POL_NA(-1, "N/A", "Not Applicable", null),
    POL_OX(0, "OX", "O and X polarizations", new Polarization[]{Polarization.ORDINARY, Polarization.EXTRAORDINARY}),
    POL_O(1, "O", "O-polarization", new Polarization[]{Polarization.ORDINARY}),
    POL_X(2, "X", "X-polarization", new Polarization[]{Polarization.EXTRAORDINARY}),
    POL_LINEAR(3, "L", "linear polarization", null);

    private static int hashSize;
    private static float hashLoadFactor;
    private static final Map<Integer, Polarizations> mapById;
    private static final Map<String, Polarizations> mapByName;
    private final int id;
    private final String name;
    private final String desc;
    private final Polarization[] sequence;

    static {
        hashSize = 2 * Polarizations.values().length + 1;
        hashLoadFactor = 0.5f;
        mapById = new HashMap<Integer, Polarizations>(hashSize, hashLoadFactor);
        mapByName = new HashMap<String, Polarizations>(hashSize, hashLoadFactor);
        Polarizations[] polarizationsArray = Polarizations.values();
        int n = polarizationsArray.length;
        int n2 = 0;
        while (n2 < n) {
            Polarizations law = polarizationsArray[n2];
            if (mapById.put(law.getId(), law) != null) {
                throw new RuntimeException("design error: id " + law.getId() + " is duplicated");
            }
            if (mapByName.put(law.getName(), law) != null) {
                throw new RuntimeException("design error: name " + law.getName() + " is duplicated.");
            }
            ++n2;
        }
    }

    private Polarizations(int id, String name, String desc, Polarization[] sequence) {
        this.id = id;
        this.name = name;
        this.desc = desc;
        this.sequence = sequence;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Polarization[] getSequence() {
        return this.sequence;
    }

    public String toString() {
        return this.getName();
    }

    public static Polarizations get(int id) {
        return mapById.get(id);
    }

    public static Polarizations get(String name) {
        return mapByName.get(name);
    }
}

