/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.radio;

import edu.uml.lgdc.datatype.geom.R3;
import edu.uml.lgdc.instrument.constants.TxMode;
import edu.uml.lgdc.time.TimeScale;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class SkymapPoint {
    protected final TimeScale time;
    protected final double freq_kHz;
    protected double range_km = 9999.0;
    protected double path_km = 9999.0;
    protected final double zenith_deg;
    protected final double azimuth_deg;
    protected final double dopplerShift_Hz;
    protected final double snr_dB;
    protected final double fitErr_deg;
    protected final double amplitude_dB;
    protected final double[] antennaPhases;
    protected final TxMode txMode;
    protected boolean enforcedPathContent = false;
    private transient int hashcode;
    private transient boolean hashcodeSet;
    private static final double TO_RAD = Math.PI / 180;

    public SkymapPoint(TimeScale time, double freq_kHz, double range_km, double zenith_deg, double azimuth_deg, double dopplerShift_Hz, double fitErr_deg, double amplitude_dB, double snr_dB, double[] antennaPhases, TxMode txMode) {
        if (time == null) {
            throw new IllegalArgumentException("time == null");
        }
        this.time = time;
        this.freq_kHz = freq_kHz;
        this.range_km = range_km;
        this.path_km = range_km * 2.0;
        this.zenith_deg = zenith_deg;
        this.azimuth_deg = azimuth_deg;
        this.dopplerShift_Hz = dopplerShift_Hz;
        this.fitErr_deg = fitErr_deg;
        this.amplitude_dB = amplitude_dB;
        this.snr_dB = snr_dB;
        this.antennaPhases = antennaPhases;
        this.txMode = txMode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SkymapPoint sp = (SkymapPoint)obj;
        return sp.time.equals(this.time) && this.freqToHz(sp.freq_kHz) == this.freqToHz(this.freq_kHz) && this.distToM(sp.getRange_km()) == this.distToM(this.range_km) && this.doppToMicroHz(sp.dopplerShift_Hz) == this.doppToMicroHz(this.dopplerShift_Hz);
    }

    public int hashCode() {
        if (!this.hashcodeSet) {
            int result = 67;
            result = 31 * result + this.time.hashCode();
            result = 31 * result + this.freqToHz(this.freq_kHz);
            result = 31 * result + this.distToM(this.range_km);
            this.hashcode = result = 31 * result + this.doppToMicroHz(this.dopplerShift_Hz);
            this.hashcodeSet = true;
        }
        return this.hashcode;
    }

    private int freqToHz(double freq_kHz) {
        return (int)Math.rint(1000.0 * freq_kHz);
    }

    private int distToM(double dist_km) {
        return (int)Math.rint(1000.0 * dist_km);
    }

    private int doppToMicroHz(double doppShift_Hz) {
        return (int)Math.rint(1000000.0 * doppShift_Hz);
    }

    public TimeScale getTime() {
        return this.time;
    }

    public double getFreq_kHz() {
        return this.freq_kHz;
    }

    public double getFreq_MHz() {
        return this.freq_kHz / 1000.0;
    }

    public double getRange_km() {
        return this.range_km;
    }

    public double getPath_km() {
        return this.path_km;
    }

    public double getPathOrRange_km() {
        return this.getPathContent() ? this.path_km : this.range_km;
    }

    public void setRange_km(double range_km) {
        this.range_km = range_km;
        this.path_km = range_km * 2.0;
    }

    public void setPath_km(double path_km) {
        this.path_km = path_km;
        this.range_km = path_km / 2.0;
    }

    public double getZenith_deg() {
        return this.zenith_deg;
    }

    public double getZenith_rad() {
        return this.zenith_deg * (Math.PI / 180);
    }

    public double getElevation_deg() {
        return 90.0 - this.zenith_deg;
    }

    public double getElevation_rad() {
        return 1.5707963267948966 - this.getZenith_rad();
    }

    public double getAzimuth_deg() {
        return this.azimuth_deg;
    }

    public double getAzimuth_rad() {
        return this.azimuth_deg * (Math.PI / 180);
    }

    public double getDopplerShift_Hz() {
        return this.dopplerShift_Hz;
    }

    public double getFitErr_deg() {
        return this.fitErr_deg;
    }

    public double getAmplitude_dB() {
        return this.amplitude_dB;
    }

    public double getSNR_dB() {
        return this.snr_dB;
    }

    public double[] getAntennaPhases() {
        return this.antennaPhases;
    }

    public R3 getSpaceCoords_km() {
        return R3.sphericalToR3(this.range_km / 2.0, Math.toRadians(this.azimuth_deg), Math.toRadians(this.zenith_deg));
    }

    public TxMode getTxMode() {
        return this.txMode;
    }

    public boolean getPathContent() {
        return this.enforcedPathContent || this.txMode == TxMode.TX_DISABLED_CW_LISTEN || this.txMode == TxMode.TX_DISABLED_SYNCED_D2D;
    }

    public boolean getDistanceContent() {
        return this.txMode == TxMode.TX_ENABLED_VERTICAL || this.txMode == TxMode.TX_ENABLED_SYNCED_D2D;
    }

    public boolean getEnforcedPathContent() {
        return this.enforcedPathContent;
    }

    public void setEnforcedPathContent(boolean v) {
        this.enforcedPathContent = v;
    }

    public String toString() {
        return "(d=" + this.dopplerShift_Hz + ",p=" + this.path_km + ",z=" + this.zenith_deg + ",a=" + this.azimuth_deg + ",snr=" + this.snr_dB + ",err=" + this.fitErr_deg + ")";
    }

    public static <T extends SkymapPoint> Collection<T> chooseAndOrderBestBySNR(Collection<T> collectionOfPoints, int howManyToChoose) {
        assert (howManyToChoose < collectionOfPoints.size());
        ArrayList<T> list = new ArrayList<T>(collectionOfPoints);
        Collections.sort(list, new Comparator<SkymapPoint>(){

            @Override
            public int compare(SkymapPoint o1, SkymapPoint o2) {
                double diff = o1.getSNR_dB() - o2.getSNR_dB();
                return diff < 0.0 ? 1 : (diff > 0.0 ? -1 : 0);
            }
        });
        ArrayList<SkymapPoint> newCollectionOfPoints = new ArrayList<SkymapPoint>(howManyToChoose);
        int i = 0;
        while (i < howManyToChoose) {
            newCollectionOfPoints.add((SkymapPoint)list.get(i));
            ++i;
        }
        return newCollectionOfPoints;
    }

    public static enum Content {
        CARRIER_FREQUENCY,
        VIRTUAL_RANGE,
        GROUP_PATH_LENGTH,
        DOPPLER_FREQUENCY,
        ANGLE_OF_ARRIVAL,
        ZENITH,
        AZIMUTH,
        SNR,
        FIT_ERROR,
        AMPLITUDE;

    }
}

