/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.radio;

import edu.uml.lgdc.format.Formatter;
import edu.uml.lgdc.instrument.constants.TxMode;
import edu.uml.lgdc.radio.SkymapPoint;
import edu.uml.lgdc.time.TimeScale;
import java.io.Serializable;

public class SkymapPointDTO
implements Serializable {
    private static final String STANDARD_EXPORT_COLUMN_HEADER = String.valueOf(Formatter.padRight("Date/Time", 19)) + Formatter.padLeft("path_km", 10) + Formatter.padLeft("dopp_Hz", 10) + Formatter.padLeft("zen_deg", 10) + Formatter.padLeft("azim_deg", 10);
    private static final String FULL_EXPORT_COLUMN_HEADER = String.valueOf(STANDARD_EXPORT_COLUMN_HEADER) + Formatter.padLeft("SNR_dB", 10) + Formatter.padLeft("FitErr_deg", 11) + Formatter.padLeft("Amp_dB", 10);
    private static final long serialVersionUID = 1L;
    private final TimeScale time;
    private final double range_km;
    private final double path_km;
    private final double zenith_deg;
    private final double azimuth_deg;
    private final double dopplerShift_Hz;
    private final double snr_dB;
    private final double fitErr_deg;
    private final double amplitude_dB;
    private final TxMode txMode;
    private final boolean enforcePathContent;

    private SkymapPointDTO(TimeScale time, double range_km, double zenith_deg, double azimuth_deg, double dopplerShift_Hz, double snr_dB, double fitErr_deg, double amplitude_dB, TxMode txMode, boolean enforcePathContent) {
        if (time == null) {
            throw new IllegalArgumentException("time == null");
        }
        this.time = time;
        this.range_km = range_km;
        this.path_km = range_km * 2.0;
        this.zenith_deg = zenith_deg;
        this.azimuth_deg = azimuth_deg;
        this.dopplerShift_Hz = dopplerShift_Hz;
        this.snr_dB = snr_dB;
        this.fitErr_deg = fitErr_deg;
        this.amplitude_dB = amplitude_dB;
        this.txMode = txMode;
        this.enforcePathContent = enforcePathContent;
    }

    static SkymapPointDTO createFrom(SkymapPoint skymapPoint) {
        return new SkymapPointDTO(skymapPoint.getTime(), skymapPoint.getRange_km(), skymapPoint.getZenith_deg(), skymapPoint.getAzimuth_deg(), skymapPoint.getDopplerShift_Hz(), skymapPoint.getSNR_dB(), skymapPoint.getFitErr_deg(), skymapPoint.getAmplitude_dB(), skymapPoint.getTxMode(), skymapPoint.enforcedPathContent);
    }

    public TimeScale getTime() {
        return this.time;
    }

    public double getPath_km() {
        return this.path_km;
    }

    public double getZenith_deg() {
        return this.zenith_deg;
    }

    public double getAzimuth_deg() {
        return this.azimuth_deg;
    }

    public double getDopplerShift_Hz() {
        return this.dopplerShift_Hz;
    }

    public double getSnr_dB() {
        return this.snr_dB;
    }

    public double getFitErr_deg() {
        return this.fitErr_deg;
    }

    public double getAmplitude_dB() {
        return this.amplitude_dB;
    }

    public TxMode getTxMode() {
        return this.txMode;
    }

    public boolean getEnforcedPathContent() {
        return this.enforcePathContent;
    }

    static String getStandardExportColumnHeader() {
        return STANDARD_EXPORT_COLUMN_HEADER;
    }

    static String getFullExportColumnHeader() {
        return FULL_EXPORT_COLUMN_HEADER;
    }

    public String standartExport() {
        return String.valueOf(this.time.toHumanUT()) + Formatter.format("%10.1f%10.3f%10.2f%10.2f", this.path_km, this.dopplerShift_Hz, this.zenith_deg, this.azimuth_deg);
    }

    public String fullExport() {
        return String.valueOf(this.time.toHumanUT()) + Formatter.format("%10.1f%10.3f%10.2f%10.2f%10.1f%11.2f%10.1f", this.dopplerShift_Hz, this.zenith_deg, this.azimuth_deg, this.snr_dB, this.fitErr_deg, this.amplitude_dB);
    }

    public String toString() {
        return this.standartExport();
    }
}

