/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.security;

import edu.uml.lgdc.project.Console;
import java.util.Objects;
import java.util.Scanner;

public class UserPass {
    protected static final char DELIMITER = '\"';
    private static final UserPass EMPTY = new UserPass();
    private static final String ERR_MSG_ILLEGAL_SYMBOLS_IN_NAME = "Only alphanumeric or underscore (_) characters are allowed in user name";
    protected static final String ERR_MSG_ILLEGAL_USERPASS = "illegal user/pass string";
    private final String username;
    private final char[] pass;

    public UserPass(String username, char[] pass) {
        this.username = Objects.requireNonNull(username);
        if (UserPass.isUsernameContainsIllegalSymbols(username)) {
            throw new IllegalArgumentException(ERR_MSG_ILLEGAL_SYMBOLS_IN_NAME);
        }
        this.pass = (char[])(pass != null ? (char[])pass.clone() : null);
    }

    protected UserPass() {
        this.username = "";
        this.pass = null;
    }

    public String getUser() {
        return this.username;
    }

    public char[] getPass() {
        return this.pass;
    }

    public void wipePass() {
        if (this.pass != null) {
            int i = 0;
            while (i < this.pass.length) {
                this.pass[i] = '\u0000';
                ++i;
            }
        }
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(128).append(this.username);
        if (this.pass != null) {
            sb.append('\"');
            int i = 0;
            while (i < this.pass.length) {
                sb.append(this.pass[i]);
                ++i;
            }
            sb.append('\"');
        }
        return sb.toString();
    }

    public static UserPass parse(String str) {
        char[] pass;
        String username;
        if (str == null || str.isEmpty()) {
            return EMPTY;
        }
        int pos = str.indexOf(34);
        if (pos >= 0) {
            if (pos == str.length() - 1 || str.charAt(str.length() - 1) != '\"') {
                Console.showError(ERR_MSG_ILLEGAL_USERPASS);
                return EMPTY;
            }
            username = str.substring(0, pos);
            int passLength = str.length() - 1 - pos - 1;
            if (passLength > 0) {
                pass = new char[passLength];
                int i = 0;
                int j = pos + 1;
                while (i < passLength) {
                    pass[i] = str.charAt(j);
                    ++i;
                    ++j;
                }
            } else {
                pass = null;
            }
        } else {
            username = str;
            pass = null;
        }
        if (UserPass.isUsernameContainsIllegalSymbols(username)) {
            Console.showError(ERR_MSG_ILLEGAL_SYMBOLS_IN_NAME);
            return EMPTY;
        }
        return new UserPass(username, pass);
    }

    public static UserPass getEmptyInstance() {
        return EMPTY;
    }

    public static UserPass ask(String title) {
        return UserPass.ask(title, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UserPass ask(String title, boolean doNotMaskPassword) {
        System.out.println(title);
        java.io.Console console = System.console();
        if (doNotMaskPassword || console == null) {
            Throwable throwable = null;
            Object var4_6 = null;
            try (Scanner scanner = new Scanner(System.in);){
                System.out.println("Username: ");
                String username = scanner.nextLine();
                if (username == null) return null;
                if (username.isEmpty()) {
                    return null;
                }
                System.out.println("Password: ");
                String password = scanner.nextLine();
                char[] chPass = !password.isEmpty() ? password.toCharArray() : null;
                return new UserPass(username, chPass);
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                }
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
                throw throwable;
            }
        }
        String username = console.readLine("Username: ", new Object[0]);
        if (username == null) return null;
        if (username.isEmpty()) {
            return null;
        }
        char[] chPass = console.readPassword("Password: ", new Object[0]);
        return new UserPass(username, chPass);
    }

    public static boolean isUsernameContainsIllegalSymbols(String username) {
        return username.matches(".*[^\\w].*");
    }

    public static String allowedCharactersForUsername() {
        return "a-z, A-Z, 1-9, or _ (underscore)";
    }
}

