/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.sftpjsch;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UserInfo;
import edu.uml.lgdc.fileio.FileUtils;
import edu.uml.lgdc.project.Console;
import edu.uml.lgdc.sftpjsch.NotInteractiveUserInfo;
import java.io.File;
import java.util.Iterator;
import java.util.Objects;
import java.util.Vector;

public class Tx {
    private static final File KNOWN_HOSTS_FILE = new File(System.getProperty("user.home"), ".jsch/known_hosts");
    private final String host;
    private final String user;
    private final String outgoingBufferDir;
    private int port = 22;
    private String dir = ".";
    private String intermediateExt = "part";
    private JSch jsch;
    private final NotInteractiveUserInfo userInfo;
    private Session session;
    private ChannelSftp channelSftp;
    private String errMsg;
    private int socketTimeout;

    public Tx(String host, String user, char[] passwd, String bufferDir) {
        this.host = Objects.requireNonNull(host);
        this.user = Objects.requireNonNull(user);
        this.userInfo = new NotInteractiveUserInfo(passwd);
        this.outgoingBufferDir = bufferDir;
        this.jsch = new JSch();
        try {
            this.jsch.setKnownHosts(KNOWN_HOSTS_FILE.getPath());
        }
        catch (JSchException ex) {
            this.jsch = null;
            Console.showError("Error reading/decoding file " + KNOWN_HOSTS_FILE);
            ex.printStackTrace();
            Console.showWarn("File " + KNOWN_HOSTS_FILE + " will be deleted and created from scratch");
        }
        if (this.jsch == null) {
            if (KNOWN_HOSTS_FILE.isFile() && !FileUtils.fileDelete(KNOWN_HOSTS_FILE)) {
                throw new RuntimeException("Cannot delete file " + KNOWN_HOSTS_FILE);
            }
            this.jsch = new JSch();
            try {
                this.jsch.setKnownHosts(KNOWN_HOSTS_FILE.getPath());
                this.cacheHostKey();
            }
            catch (JSchException ex) {
                throw new RuntimeException("Unexpected error", ex);
            }
        }
    }

    public void setTimeout(int timeout) {
        this.socketTimeout = timeout;
    }

    public void connect() throws JSchException {
        Console.showMsg("Tx:" + this.outgoingBufferDir + ": Connecting to " + this.host);
        this.session = this.jsch.getSession(this.user, this.host, this.port);
        this.session.setUserInfo((UserInfo)this.userInfo);
        this.session.setTimeout(this.socketTimeout);
        this.session.connect();
        this.channelSftp = (ChannelSftp)this.session.openChannel("sftp");
        this.channelSftp.connect();
        Console.showMsg("Tx:" + this.outgoingBufferDir + ": Connected to " + this.host);
    }

    public void disconnect() {
        if (this.session != null) {
            this.session.disconnect();
            Console.showMsg("Tx:" + this.outgoingBufferDir + ": Disconnected.");
            this.session = null;
            this.channelSftp = null;
        } else {
            Console.showMsg("Tx:" + this.outgoingBufferDir + ": Session is already null!");
        }
    }

    public boolean transfer(File file) throws JSchException {
        return this.transfer(file, true);
    }

    public boolean transfer(File file, Boolean allowRmErr) throws JSchException {
        try {
            this.connect();
            boolean bl = this.transferOneFile(file, allowRmErr);
            return bl;
        }
        finally {
            this.disconnect();
        }
    }

    public boolean transferOneFile(File file) {
        return this.transferOneFile(file, true);
    }

    public boolean transferOneFile(File file, Boolean allowRmErr) {
        this.errMsg = null;
        if (!file.isFile()) {
            this.errMsg = "Tx: Source \"" + file + "\" is not a file";
            return false;
        }
        if (!(this.dir == null || this.dir.isEmpty() || this.dir.equals(".") || this.cd(this.channelSftp, this.dir))) {
            return false;
        }
        if (!this.rm(this.channelSftp, file.getName())) {
            if (allowRmErr.booleanValue()) {
                return false;
            }
            Console.showMsg(this.errMsg);
        }
        File intermediateFile = new File(String.valueOf(file.getPath()) + "." + this.intermediateExt);
        if (!this.put(this.channelSftp, file.getPath(), intermediateFile.getName(), 1)) {
            return false;
        }
        if (!this.checkFileSize(this.channelSftp, intermediateFile.getName(), file.length())) {
            return false;
        }
        return this.rename(this.channelSftp, intermediateFile.getName(), file.getName());
    }

    private boolean cd(ChannelSftp channelSftp, String dir) {
        if (dir != null && !dir.isEmpty() && !dir.equals(".")) {
            try {
                channelSftp.cd(dir);
                return true;
            }
            catch (SftpException ex) {
                this.errMsg = "Tx: SFTP-command cd: unknown remote directory, \"" + dir + "\"";
                return false;
            }
        }
        return true;
    }

    private boolean rm(ChannelSftp channelSftp, String remoteFilename) {
        try {
            Console.showMsg("Tx:" + this.outgoingBufferDir + ": Remove remote file " + remoteFilename + " before transfer");
            channelSftp.rm(remoteFilename);
            return true;
        }
        catch (SftpException ex) {
            String str = ex.getMessage();
            if (str.toLowerCase().contains("no such file")) {
                Console.showMsg("Tx:" + this.outgoingBufferDir + ": Remove remote file failed " + remoteFilename + ": " + str);
                return true;
            }
            this.errMsg = "Tx:" + this.outgoingBufferDir + ": Remove remote file failed " + remoteFilename + ": " + str;
            return false;
        }
    }

    private boolean put(ChannelSftp channelSftp, String localFile, String remoteFile, int mode) {
        try {
            Console.showMsg("Tx:" + this.outgoingBufferDir + ": Putting local file " + localFile + " to remote file " + remoteFile);
            channelSftp.put(localFile, remoteFile, mode);
            return true;
        }
        catch (SftpException ex) {
            this.errMsg = "Tx: SFTP-command put \"" + localFile + "\" \"" + remoteFile + "\": " + ex.getMessage();
            return false;
        }
    }

    private boolean rename(ChannelSftp channelSftp, String oldFilename, String newFilename) {
        try {
            channelSftp.rename(oldFilename, newFilename);
            return true;
        }
        catch (SftpException ex) {
            this.errMsg = "Tx: SFTP-command rename \"" + oldFilename + "\" \"" + newFilename + "\": " + ex.getMessage();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean checkFileSize(ChannelSftp channelSftp, String filename, long size) {
        try {
            ChannelSftp.LsEntry lsEntry;
            Vector lsEntries = channelSftp.ls(filename);
            Iterator iterator = lsEntries.iterator();
            do {
                if (iterator.hasNext()) continue;
                this.errMsg = "Tx: SFTP-command ls " + filename + ": file " + filename + " not found";
                return false;
            } while (!(lsEntry = (ChannelSftp.LsEntry)iterator.next()).getAttrs().isReg() || !lsEntry.getFilename().equals(filename));
            if (lsEntry.getAttrs().getSize() == size) {
                return true;
            }
            this.errMsg = "Tx: source file size, " + size + ", does not equal target file size, " + lsEntry.getAttrs().getSize();
            return false;
        }
        catch (SftpException ex) {
            this.errMsg = ex.getMessage();
            return false;
        }
    }

    public void cacheHostKey() throws JSchException {
        Session session = null;
        try {
            this.userInfo.setAcceptUnknownHost(true);
            session = this.jsch.getSession(this.user, this.host, this.port);
            session.setUserInfo((UserInfo)this.userInfo);
            session.connect();
        }
        finally {
            this.userInfo.setAcceptUnknownHost(false);
            if (session != null) {
                session.disconnect();
            }
        }
    }

    public String getErrMsg() {
        return this.errMsg;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getDir() {
        return this.dir;
    }

    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getIntermediateExt() {
        return this.intermediateExt;
    }

    public void setIntermediateExt(String intermediateExt) {
        this.intermediateExt = intermediateExt;
    }
}

