/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.time;

import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.time.TimeScale;

public class RealHours {
    private double realHours;
    private double longitude = 0.0;
    private int dateOffset = 0;
    private int hours;
    private int minutes;
    private int seconds;
    private int millisecs;

    public RealHours(int hours) {
        this(hours, 0);
    }

    public RealHours(int hours, int minutes) {
        this(hours, minutes, 0);
    }

    public RealHours(int hours, int minutes, int seconds) {
        this(hours, minutes, seconds, 0);
    }

    public RealHours(int hours, int minutes, int seconds, int millisecs) {
        this(0.0, hours, minutes, seconds, millisecs);
    }

    public RealHours(double lon, int hours, int minutes, int seconds, int millisecs) {
        this.setup(lon, RealHours.toRealHours(hours, minutes, seconds, millisecs));
    }

    public RealHours(TimeScale time) {
        this(0.0, time);
    }

    public RealHours(double longitude, TimeScale time) {
        this(longitude, RealHours.toRealHours(time));
    }

    public RealHours(double realHours) {
        this(0.0, realHours);
    }

    public RealHours(double longitude, double realHours) {
        this.setup(longitude, realHours);
    }

    public double getRealHours() {
        return this.realHours;
    }

    public int getDateOffset() {
        return this.dateOffset;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getMillisecs() {
        return this.millisecs;
    }

    private void setup(double longitude, double utRealHours) {
        this.dateOffset = 0;
        if (longitude >= 360.0) {
            longitude %= 360.0;
        } else if (longitude < 0.0) {
            longitude = -longitude;
            longitude %= 360.0;
            if ((longitude = 360.0 - longitude) >= 360.0) {
                longitude = 0.0;
            }
        }
        this.longitude = longitude;
        this.realHours = utRealHours + longitude / 360.0 * 24.0;
        if (this.realHours >= 24.0) {
            this.realHours -= 24.0;
        }
        if (utRealHours < 12.0) {
            if (this.realHours > utRealHours + 12.0) {
                --this.dateOffset;
            }
        } else if (this.realHours <= utRealHours - 12.0) {
            ++this.dateOffset;
        }
        double temp = this.realHours;
        this.hours = (int)temp;
        temp = (temp - (double)this.hours) * 60.0;
        this.minutes = (int)temp;
        temp = (temp - (double)this.minutes) * 60.0;
        this.seconds = (int)temp;
        temp = (temp - (double)this.seconds) * 1000.0;
        this.millisecs = (int)temp;
    }

    public static double toRealHours(TimeScale time) {
        return RealHours.toRealHours(time.get(11), time.get(12), time.get(13), time.get(14));
    }

    public static double toRealHours(int hours, int minutes, int seconds, int millisecs) {
        return (double)hours + ((double)minutes + ((double)seconds + (double)millisecs / 1000.0) / 60.0) / 60.0;
    }

    public static String toHuman(double realHours) {
        String out = "";
        int hours = (int)realHours;
        realHours = (realHours - (double)hours) * 60.0;
        int minute = (int)realHours;
        realHours = (realHours - (double)minute) * 60.0;
        int sec = (int)realHours;
        out = String.valueOf(FC.padLeft(FC.IntegerToString(hours), 2, '0')) + ":" + FC.padLeft(FC.IntegerToString(minute), 2, '0') + ":" + FC.padLeft(FC.IntegerToString(sec), 2, '0');
        return out;
    }
}

