/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.time;

import edu.uml.lgdc.datatype.Metricable;
import edu.uml.lgdc.format.FC;
import edu.uml.lgdc.format.StrUtil;
import edu.uml.lgdc.math.Search;
import edu.uml.lgdc.time.IllegalDateTimeStringException;
import edu.uml.lgdc.time.RealHours;
import edu.uml.lgdc.time.TimeMarked;
import edu.uml.lgdc.time.TimeType;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.TimeZone;

public class TimeScale
extends GregorianCalendar
implements TimeMarked,
Metricable<TimeScale> {
    static final long serialVersionUID = 8506009477987519770L;
    public static final String TIME_FORMAT_FOR_TO_STRING = "yyyy.MM.dd HH:mm:ss.SSS";
    public static final int FIELD_NOT_SET = -1;
    public static final int FIELD_ERROR = -999;
    public static final int MILLISECONDS_PER_SECOND = 1000;
    public static final int SECONDS_PER_MINUTE = 60;
    public static final int MINUTES_PER_HOUR = 60;
    public static final int HOURS_PER_DAY = 24;
    public static final int MONTHS_PER_YEAR = 12;
    public static final double DAYS_PER_YEAR = 365.2425;
    public static final int MINUTES_PER_DAY = 1440;
    public static final int SECONDS_PER_DAY = 86400;
    public static final int MILLISECONDS_PER_DAY = 86400000;
    public static final int MILLISECONDS_PER_MINUTE = 60000;
    public static final int MILLISECONDS_PER_HOUR = 3600000;
    protected static final int[] daysPerMonths = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    protected static final String[] shortNamesOfMonths = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
    protected static final String[] fullNamesOfMonths = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};
    public static final TimeZone tzUTC = TimeZone.getTimeZone("UTC");
    private static final int[] maxDaysPerMonth = new int[]{31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    public static final TimeScale TM = new TimeScale();
    public static final String DIGITS = "0123456789";
    private static final String[] DATE_TIME_POPULAR_FORMATS = new String[]{"yyyy.MM.dd (DDD) HH:mm:ss.SSS", "yyyy.MM.dd (DDD) HH:mm:ss", "yyyy.MM.dd HH:mm:ss.SSS", "yyyy.MM.dd HH:mm:ss", "yyyy.MM.dd HH:mm", "yyyy.MM.dd HH", "yyyy.MM.dd"};
    private static final double COEF_DEG_TO_MIN = 4.0;

    public TimeScale(int year, int month, int day, int hour, int minute, int sec) {
        this(year, month, day, hour, minute, sec, 0);
    }

    public TimeScale(int year, int month, int day, int hour, int minute, int sec, int millisec) {
        super(year, month, day, hour, minute, sec);
        this.setTimeZone(tzUTC);
        this.set(14, millisec);
    }

    public TimeScale() {
        this(tzUTC);
    }

    public TimeScale(TimeZone tz) {
        super(tz);
    }

    public TimeScale(long dateTimeInMillis) {
        this.setTimeZone(tzUTC);
        this.setTimeInMillis(dateTimeInMillis);
    }

    public TimeScale(double dateTimeInMinute) {
        this.setTimeZone(tzUTC);
        this.setTimeInMillis(Math.round(dateTimeInMinute * 60.0 * 1000.0));
    }

    public TimeScale(String dateStr, String formatString) throws ParseException {
        this(dateStr, formatString, false);
    }

    public TimeScale(String dateStr, String formatString, boolean strict) throws ParseException {
        this.setTimeZone(tzUTC);
        this.set(dateStr, formatString, strict);
    }

    public TimeScale(String timeString) {
        timeString = Objects.requireNonNull(timeString).trim();
        this.setTimeZone(tzUTC);
        try {
            int[] datetime = TimeScale.decode(timeString);
            this.set(datetime[0], datetime[1], datetime[2], datetime[3], datetime[4], datetime[5]);
            this.set(14, datetime[6]);
        }
        catch (IllegalDateTimeStringException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static TimeScale parseNoException(String timeString) {
        try {
            return TimeScale.parse(timeString, false);
        }
        catch (IllegalDateTimeStringException e) {
            return null;
        }
    }

    public static TimeScale parseNoException(String timeString, boolean allowAnythingAfterMilliseconds) {
        try {
            return TimeScale.parse(timeString, allowAnythingAfterMilliseconds);
        }
        catch (IllegalDateTimeStringException e) {
            return null;
        }
    }

    public static TimeScale parse(String timeString) throws IllegalDateTimeStringException {
        return TimeScale.parse(timeString, false);
    }

    public static TimeScale parse(String timeString, boolean allowAnythingAfterMilliseconds) throws IllegalDateTimeStringException {
        int[] t = TimeScale.decode(timeString, allowAnythingAfterMilliseconds);
        return new TimeScale(t[0], t[1], t[2], t[3], t[4], t[5], t[6]);
    }

    public static int[] decode(String timeString) throws IllegalDateTimeStringException {
        return TimeScale.decode(timeString, false);
    }

    public static int[] decode(String timeString, boolean allowAnythingAfterMilliseconds) throws IllegalDateTimeStringException {
        int year;
        int dayOfYear;
        int msec;
        int sec;
        int minute;
        int hour;
        int day;
        int month;
        block55: {
            String tmpString;
            int i;
            block57: {
                char dateDelim;
                block56: {
                    char[] dateDelimiters;
                    block54: {
                        dateDelimiters = new char[]{'.', '/', '-'};
                        int timeDelim = 58;
                        timeString = Objects.requireNonNull(timeString).trim();
                        month = 1;
                        day = 1;
                        hour = 0;
                        minute = 0;
                        sec = 0;
                        msec = 0;
                        dayOfYear = -1;
                        if (timeString.length() < 4) {
                            throw new IllegalDateTimeStringException("string is too short");
                        }
                        i = 0;
                        tmpString = timeString.substring(i, i + 4);
                        try {
                            year = Integer.parseInt(tmpString);
                        }
                        catch (NumberFormatException ex) {
                            throw new IllegalDateTimeStringException("bad year, " + tmpString);
                        }
                        if (year <= 0) {
                            throw new IllegalDateTimeStringException("bad year, " + tmpString);
                        }
                        if (timeString.length() >= 7) break block54;
                        if (timeString.length() != 4) {
                            throw new IllegalDateTimeStringException("garbage at the end " + timeString);
                        }
                        break block55;
                    }
                    i = 5;
                    dateDelim = timeString.charAt(i - 1);
                    if (Search.scan(dateDelimiters, dateDelim) < 0) {
                        throw new IllegalDateTimeStringException("illegal date delimiter, " + dateDelim);
                    }
                    tmpString = timeString.substring(i, i + 2);
                    try {
                        month = Integer.parseInt(tmpString);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalDateTimeStringException("bad month, " + tmpString);
                    }
                    if (!TimeScale.checkMonth(month)) {
                        throw new IllegalDateTimeStringException("bad month, " + tmpString);
                    }
                    if (timeString.length() >= 10) break block56;
                    if (timeString.length() != 7) {
                        throw new IllegalDateTimeStringException("garbage at the end " + timeString);
                    }
                    break block55;
                }
                i = 8;
                if (dateDelim != timeString.charAt(i - 1)) {
                    throw new IllegalDateTimeStringException("illegal or inconsistent date delimiter(s), " + timeString);
                }
                tmpString = timeString.substring(i, i + 2);
                try {
                    day = Integer.parseInt(tmpString);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalDateTimeStringException("bad day, " + tmpString);
                }
                if (!TimeScale.checkDay(day)) {
                    throw new IllegalDateTimeStringException("bad day, " + tmpString);
                }
                if (timeString.length() <= i + 3 || timeString.charAt(i + 3) != '(') break block57;
                if (timeString.length() < i + 8 || timeString.charAt(i + 7) != ')') {
                    throw new IllegalDateTimeStringException("garbage at the end " + timeString);
                }
                tmpString = timeString.substring(i + 4, i + 7);
                try {
                    dayOfYear = Integer.parseInt(tmpString);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalDateTimeStringException("bad day of year, " + tmpString);
                }
                if (!TimeScale.checkDayOfYear(year, dayOfYear)) {
                    throw new IllegalDateTimeStringException("bad day of year, " + tmpString);
                }
                if (timeString.length() == i + 8) break block55;
                i += 6;
            }
            if (timeString.length() < i + 5) {
                if (timeString.length() != i + 2) {
                    throw new IllegalDateTimeStringException("garbage at the end " + timeString);
                }
            } else {
                i += 3;
                if (dayOfYear > 0) {
                    if (timeString.charAt(i - 1) != ' ' || timeString.charAt(i - 7) != ' ') {
                        throw new IllegalDateTimeStringException("before and after (DDD) has to be one space symbol " + timeString);
                    }
                } else if (timeString.charAt(i - 1) != ' ' && timeString.charAt(i - 1) != 'T') {
                    throw new IllegalDateTimeStringException("between date and time parts has to be either space or letter T, " + timeString);
                }
                tmpString = timeString.substring(i, i + 2);
                try {
                    hour = Integer.parseInt(tmpString);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalDateTimeStringException("bad hour, " + tmpString);
                }
                if (!TimeScale.checkHour(hour)) {
                    throw new IllegalDateTimeStringException("bad hour, " + tmpString);
                }
                if (timeString.length() < i + 5) {
                    if (timeString.length() != i + 2) {
                        throw new IllegalDateTimeStringException("garbage at the end " + timeString);
                    }
                } else {
                    if (':' != timeString.charAt((i += 3) - 1)) {
                        throw new IllegalDateTimeStringException("illegal time delimiter, " + timeString);
                    }
                    tmpString = timeString.substring(i, i + 2);
                    try {
                        minute = Integer.parseInt(tmpString);
                    }
                    catch (NumberFormatException ex) {
                        throw new IllegalDateTimeStringException("bad minute, " + tmpString);
                    }
                    if (!TimeScale.checkMinute(minute)) {
                        throw new IllegalDateTimeStringException("bad minute, " + tmpString);
                    }
                    if (timeString.length() < i + 5) {
                        if (timeString.length() != i + 2) {
                            throw new IllegalDateTimeStringException("garbage at the end " + timeString);
                        }
                    } else {
                        if (':' != timeString.charAt((i += 3) - 1)) {
                            throw new IllegalDateTimeStringException("illegal time delimiter, " + timeString);
                        }
                        tmpString = timeString.substring(i, i + 2);
                        try {
                            sec = Integer.parseInt(tmpString);
                        }
                        catch (NumberFormatException ex) {
                            throw new IllegalDateTimeStringException("bad second, " + tmpString);
                        }
                        if (!TimeScale.checkSecond(sec)) {
                            throw new IllegalDateTimeStringException("bad second, " + tmpString);
                        }
                        if (timeString.length() < i + 6) {
                            if (timeString.length() != i + 2) {
                                throw new IllegalDateTimeStringException("garbage at the end " + timeString);
                            }
                        } else {
                            if (timeString.charAt((i += 3) - 1) != '.') {
                                throw new IllegalDateTimeStringException("illegal time delimiter between seconds and milliseconds, " + timeString);
                            }
                            tmpString = timeString.substring(i, i + 3);
                            try {
                                msec = Integer.parseInt(tmpString);
                            }
                            catch (NumberFormatException ex) {
                                throw new IllegalDateTimeStringException("bad millisecond, " + tmpString);
                            }
                            if (!TimeScale.checkMilliSecond(msec)) {
                                throw new IllegalDateTimeStringException("bad millisecond, " + tmpString);
                            }
                            if (!allowAnythingAfterMilliseconds && timeString.length() > i + 3) {
                                throw new IllegalDateTimeStringException("garbage at the end " + timeString);
                            }
                        }
                    }
                }
            }
        }
        if (!TimeScale.checkDate(year, month, day)) {
            throw new IllegalDateTimeStringException("year, month and day are inconsistent");
        }
        if (dayOfYear > 0 && (month != TimeScale.getMonth(year, dayOfYear) || day != TimeScale.getDayInMonth(year, dayOfYear))) {
            throw new IllegalDateTimeStringException("year, month, day, and day of year are inconsistent");
        }
        return new int[]{year, --month, day, hour, minute, sec, msec};
    }

    @Override
    public boolean before(Object obj) {
        boolean result = false;
        if (obj instanceof TimeScale) {
            result = super.before(obj);
        }
        return result;
    }

    @Override
    public double dist(TimeScale time) {
        if (time != null) {
            return Math.abs(this.diffIn(12, time));
        }
        return Double.NaN;
    }

    @Override
    public void complete() {
        super.complete();
    }

    public void setTimeInMilliSeconds(long dateTimeInMillis) {
        this.setTimeInMillis(dateTimeInMillis);
    }

    public void setTimeInSeconds(long dateTimeInSeconds) {
        this.setTimeInMillis(dateTimeInSeconds * 1000L);
    }

    public void setTimeInMinutes(double dateTimeInMinute) {
        this.setTimeInMillis(Math.round(dateTimeInMinute * 60.0 * 1000.0));
    }

    public void setTime(TimeScale dateTime) {
        this.setTimeInMillis(dateTime.getTimeInMillis());
    }

    public long getTimeInMilliSeconds() {
        return this.getTimeInMillis();
    }

    public double getTimeInSeconds() {
        return this.getTimeIn(13);
    }

    @Override
    public double getTimeInMinutes() {
        return this.getTimeIn(12);
    }

    public double getWholeTimeInSeconds() {
        return this.getWholeTimeIn(13);
    }

    public double getWholeTimeInMinutes() {
        return this.getWholeTimeIn(12);
    }

    public String getAsString() {
        int year = this.get(1);
        int month = this.get(2) + 1;
        String str = "" + year;
        str = String.valueOf(str) + "." + FC.IntegerToString(month, 2).replace(' ', '0');
        str = String.valueOf(str) + "." + FC.IntegerToString(this.get(5), 2).replace(' ', '0');
        str = String.valueOf(str) + " " + FC.IntegerToString(this.get(11), 2).replace(' ', '0');
        str = String.valueOf(str) + ":" + FC.IntegerToString(this.get(12), 2).replace(' ', '0');
        str = String.valueOf(str) + ":" + FC.IntegerToString(this.get(13), 2).replace(' ', '0');
        return str;
    }

    public String toFormatUT(String formatString) {
        SimpleDateFormat formatter = new SimpleDateFormat(formatString);
        formatter.setTimeZone(this.getTimeZone());
        return formatter.format(this.getTime());
    }

    public String toFormatISO8601() {
        TimeZone timeZone = this.getTimeZone();
        if (timeZone == tzUTC) {
            return this.toFormatUT("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        }
        int offset_min = timeZone.getOffset(this.getTimeInMillis()) / 60000;
        String sign = offset_min >= 0 ? "+" : "-";
        offset_min = Math.abs(offset_min);
        return String.valueOf(this.toFormatUT("yyyy-MM-dd'T'HH:mm:ss.SSS")) + sign + FC.padLeft(FC.IntegerToString(offset_min / 60), 2, '0') + ":" + FC.padLeft(FC.IntegerToString(offset_min % 60), 2, '0');
    }

    public String toIonexEpoch() {
        return String.valueOf(FC.IntegerToString(this.get(1), 6)) + FC.IntegerToString(this.get(2) + 1, 6) + FC.IntegerToString(this.get(5), 6) + FC.IntegerToString(this.get(10), 6) + FC.IntegerToString(this.get(12), 6) + FC.IntegerToString(this.get(13), 6) + FC.nC2S(' ', 24);
    }

    public void set(String dateStr, String formStr) throws ParseException {
        this.set(dateStr, formStr, false);
    }

    public void set(String dateStr, String formStr, boolean strict) throws ParseException {
        dateStr = dateStr.replace('/', '.').replace('-', '.');
        formStr = formStr.replace('/', '.').replace('-', '.');
        SimpleDateFormat formatter = new SimpleDateFormat(formStr);
        formatter.setLenient(!strict);
        formatter.setTimeZone(tzUTC);
        this.setTimeZone(tzUTC);
        this.setTime(formatter.parse(dateStr));
    }

    public static TimeScale parse(String dateStr, String formStr) throws ParseException {
        return TimeScale.parse(dateStr, formStr, false);
    }

    public static TimeScale parse(String dateStr, String formStr, boolean strict) throws ParseException {
        TimeScale time = new TimeScale();
        time.set(dateStr, formStr, strict);
        return time;
    }

    public static TimeScale parseSmart(String dateStr) throws ParseException {
        TimeScale time = new TimeScale();
        dateStr = dateStr.replace('/', '.').replace('-', '.').replaceFirst("T", " ");
        int i = 0;
        while (i < DATE_TIME_POPULAR_FORMATS.length) {
            String formStr = DATE_TIME_POPULAR_FORMATS[i];
            SimpleDateFormat formatter = new SimpleDateFormat(formStr);
            formatter.setLenient(false);
            formatter.setTimeZone(tzUTC);
            if (i < DATE_TIME_POPULAR_FORMATS.length - 1) {
                try {
                    time.setTime(formatter.parse(dateStr));
                    break;
                }
                catch (ParseException parseException) {
                }
            } else {
                time.setTime(formatter.parse(dateStr));
            }
            ++i;
        }
        return time;
    }

    public String toUT() {
        return this.toFormatUT("yyyy-MMM-dd (DDD) HH:mm:ss");
    }

    public String toShortUT() {
        return this.toFormatUT("yyyy.MM.dd (DDD) HH:mm:ss");
    }

    public String toHumanUT() {
        return this.toFormatUT("yyyy.MM.dd HH:mm:ss");
    }

    public String toDateUT() {
        return this.toFormatUT("yyyy.MM.dd (DDD)");
    }

    public String toShortDateUT() {
        return this.toFormatUT("yyyy.MM.dd");
    }

    public String toTimeUT() {
        return this.toFormatUT("HH:mm:ss");
    }

    public String toTimestamp() {
        return this.toFormatUT("yyyy/MM/dd HH:mm:ss.SSS");
    }

    public String toFilename() {
        return this.toFormatUT("yyyyMMddHHmmss");
    }

    public String toFilenameAternative() {
        return this.toFormatUT("yyyyMMdd_HHmmss");
    }

    @Override
    public String toString() {
        return this.toFormatUT(TIME_FORMAT_FOR_TO_STRING);
    }

    public String toFilename_ms() {
        return this.toFormatUT("yyyyMMddHHmmssSSS");
    }

    public String toFilenameAlternative_ms() {
        return this.toFormatUT("yyyyMMdd_HHmmssSSS");
    }

    public int numberOfDaysInMonth() {
        return this.numberOfDaysInMonth(this.get(2) + 1, this.get(1));
    }

    public int numberOfDaysInMonth(int month, int year) {
        return this.isLeapYear(year) && month == 2 ? 29 : daysPerMonths[month - 1];
    }

    public void addMillis(long ms) {
        this.setTimeInMillis(ms + this.getTimeInMillis());
    }

    public String getShortNameOfMonth() {
        return shortNamesOfMonths[this.get(2)];
    }

    public static String shortNameOfMonth(int numberOfMonth) {
        return shortNamesOfMonths[numberOfMonth - 1];
    }

    public static String fullNameOfMonth(int numberOfMonth) {
        return fullNamesOfMonths[numberOfMonth - 1];
    }

    public static int monthToNumber(String month) {
        month = month.toUpperCase();
        int i = 0;
        while (i < shortNamesOfMonths.length) {
            if (month.equals(shortNamesOfMonths[i].toUpperCase())) {
                return i + 1;
            }
            if (month.equals(fullNamesOfMonths[i].toUpperCase())) {
                return i + 1;
            }
            ++i;
        }
        return -1;
    }

    public boolean isLeapYear() {
        return super.isLeapYear(this.get(1));
    }

    public int numberOfDaysInYear() {
        return this.isLeapYear() ? 366 : 365;
    }

    public int numberOfDaysInYear(int year) {
        return this.isLeapYear(year) ? 366 : 365;
    }

    public double getTimeIn(int field) {
        double time = 0.0;
        switch (field) {
            case 14: {
                time = this.getTimeInMillis();
                break;
            }
            case 13: {
                time = (double)this.getTimeInMillis() / 1000.0;
                break;
            }
            case 12: {
                time = (double)this.getTimeInMillis() / 60000.0;
                break;
            }
            case 11: {
                time = (double)this.getTimeInMillis() / 3600000.0;
                break;
            }
            case 5: {
                time = (double)this.getTimeInMillis() / 8.64E7;
                break;
            }
            case 2: {
                time = (double)(12 * this.get(1) + this.get(2)) + ((double)(this.get(5) - 1) + this.getTimeSinceMidnightIn(5)) / (double)this.numberOfDaysInMonth();
                break;
            }
            case 1: {
                time = this.getTimeIn(11) / 365.2425;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return time;
    }

    public long getWholeTimeIn(int field) {
        return (long)Math.floor(this.getTimeIn(field));
    }

    public long getNextWholeTimeIn(int field) {
        return (long)Math.ceil(this.getTimeIn(field));
    }

    public double getTimeSinceMidnightIn(int field) {
        double time = 0.0;
        switch (field) {
            case 14: {
                time = this.get(12) + 60 * this.get(11);
                time = (double)this.get(13) + 60.0 * time;
                time = (double)this.get(14) + 1000.0 * time;
                break;
            }
            case 13: {
                time = this.getTimeSinceMidnightIn(14) / 1000.0;
                break;
            }
            case 12: {
                time = this.getTimeSinceMidnightIn(14) / 60000.0;
                break;
            }
            case 11: {
                time = this.getTimeSinceMidnightIn(14) / 3600000.0;
                break;
            }
            case 5: {
                time = this.getTimeSinceMidnightIn(14) / 8.64E7;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return time;
    }

    public double diffIn(int field, TimeScale otherTime) {
        return this.getTimeIn(field) - otherTime.getTimeIn(field);
    }

    public long diffWholeIn(int field, TimeScale otherTime) {
        return this.getWholeTimeIn(field) - otherTime.getWholeTimeIn(field);
    }

    public TimeScale startOfYear() {
        TimeScale startOfYear = (TimeScale)this.clone();
        startOfYear.set(2, 0);
        startOfYear.set(5, 1);
        startOfYear.set(11, 0);
        startOfYear.set(12, 0);
        startOfYear.set(13, 0);
        startOfYear.set(14, 0);
        return startOfYear;
    }

    public TimeScale endOfYear() {
        TimeScale endOfYear = (TimeScale)this.clone();
        endOfYear.add(1, 1);
        endOfYear.set(2, 0);
        endOfYear.set(5, 1);
        endOfYear.set(11, 0);
        endOfYear.set(12, 0);
        endOfYear.set(13, 0);
        endOfYear.set(14, 0);
        endOfYear.add(14, -1);
        return endOfYear;
    }

    public TimeScale startOfMonth() {
        TimeScale startOfMonth = (TimeScale)this.clone();
        startOfMonth.set(5, 1);
        startOfMonth.set(11, 0);
        startOfMonth.set(12, 0);
        startOfMonth.set(13, 0);
        startOfMonth.set(14, 0);
        return startOfMonth;
    }

    public TimeScale endOfMonth() {
        TimeScale endOfMonth = (TimeScale)this.clone();
        endOfMonth.add(2, 1);
        endOfMonth.set(5, 1);
        endOfMonth.set(11, 0);
        endOfMonth.set(12, 0);
        endOfMonth.set(13, 0);
        endOfMonth.set(14, 0);
        endOfMonth.add(14, -1);
        return endOfMonth;
    }

    public TimeScale startOfDay() {
        TimeScale startOfDay = (TimeScale)this.clone();
        startOfDay.set(11, 0);
        startOfDay.set(12, 0);
        startOfDay.set(13, 0);
        startOfDay.set(14, 0);
        return startOfDay;
    }

    public TimeScale endOfDay() {
        TimeScale endOfDay = (TimeScale)this.clone();
        endOfDay.add(5, 1);
        endOfDay.set(11, 0);
        endOfDay.set(12, 0);
        endOfDay.set(13, 0);
        endOfDay.set(14, 0);
        endOfDay.add(14, -1);
        return endOfDay;
    }

    public TimeScale startOfHour() {
        TimeScale startOfHour = (TimeScale)this.clone();
        startOfHour.set(12, 0);
        startOfHour.set(13, 0);
        startOfHour.set(14, 0);
        return startOfHour;
    }

    public TimeScale endOfHour() {
        TimeScale endOfHour = (TimeScale)this.clone();
        endOfHour.add(11, 1);
        endOfHour.set(12, 0);
        endOfHour.set(13, 0);
        endOfHour.set(14, 0);
        endOfHour.add(14, -1);
        return endOfHour;
    }

    public TimeScale startOfMinute() {
        TimeScale startOfMinute = (TimeScale)this.clone();
        startOfMinute.set(13, 0);
        startOfMinute.set(14, 0);
        return startOfMinute;
    }

    public TimeScale endOfMinute() {
        TimeScale endOfMinute = (TimeScale)this.clone();
        endOfMinute.add(12, 1);
        endOfMinute.set(13, 0);
        endOfMinute.set(14, 0);
        endOfMinute.add(14, -1);
        return endOfMinute;
    }

    public static TimeScale getTimestampFromString(String strTimeStamp, String formatStr) throws ParseException {
        return TimeScale.getTimestampFromString(strTimeStamp, formatStr, false);
    }

    public static TimeScale getTimestampFromString(String strTimeStamp, String formatStr, boolean strict) throws ParseException {
        int mSecs = 0;
        int pos = strTimeStamp.lastIndexOf(46);
        if (pos >= 0) {
            String mSecStr = StrUtil.trimRight(strTimeStamp.substring(pos + 1));
            if (mSecStr.length() > 0) {
                if (!StrUtil.isOnlyDigits(mSecStr)) {
                    if (!strict) {
                        if ((mSecStr = mSecStr.substring(0, StrUtil.sniffOthers(mSecStr, DIGITS, 0))).length() == 0) {
                            mSecStr = "000";
                        }
                    } else {
                        throw new ParseException("illegal date format: " + strTimeStamp, pos + 1);
                    }
                }
                if (mSecStr.length() < 3) {
                    mSecStr = FC.padRight(mSecStr, 3, '0');
                }
                try {
                    mSecs = Integer.parseInt(mSecStr);
                }
                catch (NumberFormatException ex) {
                    if (strict) {
                        throw new ParseException("illegal date format, " + strTimeStamp + ", " + ex.getMessage(), pos + 1);
                    }
                    mSecs = 0;
                }
                if (strict && mSecs > 999) {
                    throw new ParseException("illegal number of milliseconds, " + strTimeStamp, pos + 1);
                }
            } else if (strict) {
                throw new ParseException("illegal number of milliseconds, " + strTimeStamp, pos + 1);
            }
            strTimeStamp = strTimeStamp.substring(0, pos);
        }
        TimeScale timeStamp = new TimeScale(strTimeStamp, formatStr, strict);
        timeStamp.set(14, mSecs);
        return timeStamp;
    }

    public static TimeScale createFromFields(int year, int month, int dayOfMonth, int dayOfYear, int hour, int minute, int second) {
        TimeScale time = null;
        if (year != -999 && month != -999 && dayOfMonth != -999 && dayOfYear != -999 && hour != -999 && minute != -999 && second != -999) {
            time = new TimeScale();
            if (year != -1) {
                time.set(1, year);
            } else {
                year = time.get(1);
                if (dayOfYear != -1) {
                    if (dayOfYear > time.get(6)) {
                        time.set(1, --year);
                    }
                } else if (dayOfMonth != -1 && month != -1) {
                    int dayInYear = 0;
                    int i = 0;
                    while (i < month - 1) {
                        dayInYear += daysPerMonths[i];
                        ++i;
                    }
                    dayInYear += dayOfMonth;
                    if (month > 2 && time.isLeapYear()) {
                        ++dayInYear;
                    }
                    if (dayInYear > time.get(6)) {
                        time.set(1, --year);
                    }
                }
            }
            if (hour == -1) {
                hour = 0;
            }
            if (minute == -1) {
                minute = 0;
            }
            if (second == -1) {
                second = 0;
            }
            time.set(11, hour);
            time.set(12, minute);
            time.set(13, second);
            time.set(14, 0);
            if (dayOfYear == -1) {
                if (month == -1) {
                    month = 1;
                }
                if (dayOfMonth == -1) {
                    dayOfMonth = 1;
                }
                time.set(2, month - 1);
                time.set(5, dayOfMonth);
            } else {
                time.set(6, dayOfYear);
            }
            time.complete();
            boolean result = false;
            if (!(time.get(1) != year || month != -1 && time.get(2) != month - 1 || dayOfMonth != -1 && time.get(5) != dayOfMonth || dayOfYear != -1 && time.get(6) != dayOfYear || time.get(11) != hour || time.get(12) != minute || time.get(13) != second)) {
                result = true;
            }
            if (!result) {
                time = null;
            }
        }
        return time;
    }

    public String getTimeString() {
        String timeStr = null;
        String year = "" + this.get(1);
        String month = "" + (this.get(2) + 1);
        String day = "" + this.get(5);
        String hour = "" + this.get(11);
        String min = "" + this.get(12);
        String sec = "" + this.get(13);
        timeStr = String.valueOf(FC.padLeft(year, 4, '0')) + FC.padLeft(month, 2, '0') + FC.padLeft(day, 2, '0') + FC.padLeft(hour, 2, '0') + FC.padLeft(min, 2, '0') + FC.padLeft(sec, 2, '0');
        return timeStr;
    }

    public static String millisToHHMMSS(long millis) {
        int sec = (int)Math.round((double)millis / 1000.0);
        return String.valueOf(FC.padLeft("" + sec / 3600, 2, '0')) + ":" + FC.padLeft("" + sec % 3600 / 60, 2, '0') + ":" + FC.padLeft("" + sec % 60, 2, '0');
    }

    public static String millisToShortHHMMSS(long millis) {
        int sec = (int)(millis / 1000L);
        millis = (int)(millis % 1000L);
        int hour = sec / 3600;
        int min = sec % 3600 / 60;
        sec %= 60;
        String str = "";
        if (hour > 0) {
            str = String.valueOf(str) + FC.padLeft("" + hour, 2, '0') + ":";
        }
        str = String.valueOf(str) + FC.padLeft("" + min, 2, '0') + ":" + FC.padLeft("" + sec, 2, '0');
        if (millis > 0L) {
            str = String.valueOf(str) + "." + FC.padLeft("" + millis, 3, '0');
        }
        return str;
    }

    public static double getLocalTimeShiftInMin(double longitude, TimeType localTimeType) {
        if (localTimeType == TimeType.AZT) {
            longitude = TimeScale.getAZTReferenceLogitude(longitude);
        } else if (localTimeType != TimeType.LMT) {
            throw new IllegalArgumentException("Parameter typeOfLocalTime is illegal (" + (Object)((Object)localTimeType) + ")");
        }
        return TimeScale.getLongitudeTimeShiftInMin(longitude);
    }

    public static double getAZTReferenceLogitude(double longitude) {
        if ((longitude = (double)(15L * Math.round(longitude / 15.0))) >= 360.0) {
            longitude = 0.0;
        }
        return longitude;
    }

    public static double getLongitudeTimeShiftInMin(double longitude) {
        if (longitude < 180.0) {
            return longitude * 4.0;
        }
        return (longitude - 360.0) * 4.0;
    }

    public static TimeScale getLongitudeTime(double longitude, TimeScale ut) {
        return TimeScale.getLocalMeanTime(longitude, ut);
    }

    public static TimeScale getLocalMeanTime(double longitude, TimeScale ut) {
        return new TimeScale(ut.getTimeInMinutes() + TimeScale.getLongitudeTimeShiftInMin(longitude));
    }

    public static TimeScale convertUT2Local(double longitude, TimeScale ut, TimeType localTimeType) {
        if (localTimeType == TimeType.AZT) {
            longitude = TimeScale.getAZTReferenceLogitude(longitude);
        } else if (localTimeType != TimeType.LMT) {
            throw new IllegalArgumentException("Parameter typeOfLocalTime is illegal (" + (Object)((Object)localTimeType) + ")");
        }
        return TimeScale.getLocalMeanTime(longitude, ut);
    }

    public static TimeScale convertLocal2UT(double longitude, TimeScale lt, TimeType localTimeType) {
        if (localTimeType == TimeType.AZT) {
            longitude = TimeScale.getAZTReferenceLogitude(longitude);
        } else if (localTimeType != TimeType.LMT) {
            throw new IllegalArgumentException("Parameter typeOfLocalTime is illegal (" + (Object)((Object)localTimeType) + ")");
        }
        return TimeScale.convertLMT2UT(longitude, lt);
    }

    public static TimeScale getTimeUT(double longitude, TimeScale lmt) {
        return TimeScale.convertLMT2UT(longitude, lmt);
    }

    public static TimeScale convertLMT2UT(double longitude, TimeScale lmt) {
        RealHours lmtRealHours = new RealHours(0.0, lmt);
        RealHours utRealHours = new RealHours(360.0 - longitude, lmt);
        TimeScale ut = new TimeScale(lmt.getTimeInMinutes());
        ut.set(11, utRealHours.getHours());
        ut.set(12, utRealHours.getMinutes());
        ut.set(13, utRealHours.getSeconds());
        ut.set(14, utRealHours.getMillisecs());
        double lmtHours = lmtRealHours.getRealHours();
        double utHours = utRealHours.getRealHours();
        if (utHours < 12.0) {
            if (lmtHours > utHours + 12.0) {
                ut.add(5, 1);
            }
        } else if (lmtHours <= utHours - 12.0) {
            ut.add(5, -1);
        }
        ut.complete();
        return ut;
    }

    public static TimeScale convert(double longitude, TimeScale time, TimeType sourceTimeType, TimeType targetTimeType) {
        if (!TimeScale.checkTimeType(sourceTimeType, true)) {
            throw new IllegalArgumentException("sourceTypeOfTime == " + (Object)((Object)sourceTimeType));
        }
        if (!TimeScale.checkTimeType(targetTimeType, true)) {
            throw new IllegalArgumentException("targetTypeOfTime == " + (Object)((Object)targetTimeType));
        }
        if (sourceTimeType == targetTimeType) {
            return new TimeScale(time.getTimeInMinutes());
        }
        if (sourceTimeType == TimeType.UT) {
            return TimeScale.convertUT2Local(longitude, time, targetTimeType);
        }
        if (targetTimeType == TimeType.UT) {
            return TimeScale.convertLocal2UT(longitude, time, sourceTimeType);
        }
        double longitudeDifference = sourceTimeType == TimeType.LMT ? (double)(15L * Math.round(longitude / 15.0)) - longitude : longitude - (double)(15L * Math.round(longitude / 15.0));
        return new TimeScale(time.getTimeInMinutes() + longitudeDifference * 4.0);
    }

    private static boolean checkTimeType(TimeType timeType, boolean dontThrowException) {
        if (timeType != null) {
            return true;
        }
        if (dontThrowException) {
            return false;
        }
        throw new IllegalArgumentException("timeType is null");
    }

    public static RealHours getLongitudeHours(double longitude, TimeScale ut) {
        int utHours = ut.get(11);
        int utMinutes = ut.get(12);
        int utSeconds = ut.get(13);
        int utMillisecs = ut.get(14);
        return TimeScale.getLongitudeHours(longitude, utHours, utMinutes, utSeconds, utMillisecs);
    }

    public static RealHours getLongitudeHours(double longitude, int utHours) {
        return TimeScale.getLongitudeHours(longitude, utHours, 0);
    }

    public static RealHours getLongitudeHours(double longitude, int utHours, int utMinutes) {
        return TimeScale.getLongitudeHours(longitude, utHours, utMinutes, 0);
    }

    public static RealHours getLongitudeHours(double longitude, int utHours, int utMinutes, int utSeconds) {
        return TimeScale.getLongitudeHours(longitude, utHours, utMinutes, utSeconds, 0);
    }

    public static RealHours getLongitudeHours(double longitude, int utHours, int utMinutes, int utSeconds, int utMillisecs) {
        double utRealHours = (double)utHours + ((double)utMinutes + ((double)utSeconds + (double)utMillisecs / 1000.0) / 60.0) / 60.0;
        return TimeScale.getLongitudeHours(longitude, utRealHours);
    }

    public static RealHours getLongitudeHours(double longitude, double utRealHours) {
        return new RealHours(longitude, utRealHours);
    }

    public static boolean checkYear(int year) {
        return year > 0 && year < 10000;
    }

    public static boolean checkMonth(int month) {
        return month >= 1 && month <= 12;
    }

    public static boolean checkDay(int day) {
        return day >= 1 && day <= 31;
    }

    public static boolean checkDay(int month, int day) {
        return day >= 1 && day <= TimeScale.getMaxDaysPerMonth(month);
    }

    public static boolean checkDay(int year, int month, int day) {
        return day >= 1 && day <= TimeScale.getMaxDaysPerMonth(year, month);
    }

    public static boolean checkDayOfYear(int year, int dayOfYear) {
        return dayOfYear >= 1 && dayOfYear <= (TM.isLeapYear(year) ? 366 : 365);
    }

    public static boolean checkDate(int year, int month, int day) {
        boolean ok = false;
        if (TimeScale.checkYear(year) && TimeScale.checkMonth(month) && TimeScale.checkDay(day) && day <= TimeScale.getMaxDaysPerMonth(year, month)) {
            ok = true;
        }
        return ok;
    }

    public static int getMaxDaysPerMonth(int year, int month) {
        int qty = 28;
        if (month != 2) {
            qty = maxDaysPerMonth[month - 1];
        } else if (TM.isLeapYear(year)) {
            qty = 29;
        }
        return qty;
    }

    public static int getMaxDaysPerMonth(int month) {
        return maxDaysPerMonth[month - 1];
    }

    public static boolean checkTime(int hr, int min, int sec) {
        return TimeScale.checkHour(hr) && TimeScale.checkMinute(min) && TimeScale.checkSecond(sec);
    }

    public static boolean checkHour(int hour) {
        return hour >= 0 && hour < 24;
    }

    public static boolean checkMinute(int min) {
        return min >= 0 && min < 60;
    }

    public static boolean checkSecond(int sec) {
        return sec >= 0 && sec < 60;
    }

    public static boolean checkMilliSecond(int msec) {
        return msec >= 0 && msec < 1000;
    }

    public static int getMonth(int year, int dayInYear) {
        int month = 1;
        int day = dayInYear;
        int i = 0;
        while (i < 12) {
            if ((day -= TM.numberOfDaysInMonth(i + 1, year)) <= 0) break;
            ++month;
            ++i;
        }
        if (month > 12) {
            month = -1;
        }
        return month;
    }

    public static int getDayInMonth(int year, int dayInYear) {
        int month = 1;
        int day = dayInYear;
        int i = 0;
        while (i < 12) {
            if (day <= TM.numberOfDaysInMonth(i + 1, year) || (day -= TM.numberOfDaysInMonth(i + 1, year)) <= 0) break;
            ++month;
            ++i;
        }
        if (month > 12) {
            day = -1;
        }
        return day;
    }

    public static TimeScale getHostLocalTime() {
        TimeScale time = new TimeScale();
        time.setTimeZone(TimeZone.getDefault());
        return time;
    }

    public static String prefixWithLocalTime(String message) {
        return TimeScale.prefixWithLocalTime(message, "  ");
    }

    public static String prefixWithLocalTime(String message, String separator) {
        TimeScale time = TimeScale.getHostLocalTime();
        return String.valueOf(time.toShortDateUT()) + " " + time.toTimeUT() + separator + message;
    }

    public static boolean checkTimesUniformity(TimeScale[] times, int interval_sec) {
        int i = 1;
        while (i < times.length) {
            if ((int)(times[i].getTimeInSeconds() - times[i - 1].getTimeInSeconds()) != interval_sec) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void checkTimeIntervals(TimeScale[][] seTime) {
        if (seTime[0][0].after(seTime[0][1])) {
            throw new RuntimeException("Time period number 0 has start time after end time.");
        }
        System.out.println(String.valueOf(seTime[0][0].toHumanUT()) + " " + seTime[0][1].toHumanUT());
        int iTime = 1;
        while (iTime < seTime.length) {
            if (seTime[iTime - 1][0].after(seTime[iTime][0]) || seTime[iTime - 1][1].after(seTime[iTime][0])) {
                throw new RuntimeException("Time periods should be ordered.");
            }
            if (seTime[iTime][0].after(seTime[iTime][1])) {
                throw new RuntimeException("Time period number " + iTime + " has start time after end time.");
            }
            System.out.println(String.valueOf(seTime[iTime][0].toHumanUT()) + " " + seTime[iTime][1].toHumanUT());
            ++iTime;
        }
    }
}

