/*
 * Decompiled with CFR 0.152.
 */
package edu.uml.lgdc.time;

import java.util.HashMap;
import java.util.Map;

public enum TimeType {
    UT("Universal Time", false),
    LMT("Local Mean Time", true),
    AZT("Abstract Zone Time", true);

    private static final int MIN_LOCAL_TIME_ORDINAL;
    private static final Map<String, TimeType> MAP_BY_NAME;
    private final String name;
    private final boolean local;

    static {
        MIN_LOCAL_TIME_ORDINAL = LMT.ordinal();
        MAP_BY_NAME = new HashMap<String, TimeType>();
        TimeType[] timeTypeArray = TimeType.values();
        int n = timeTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            TimeType timeType = timeTypeArray[n2];
            if (MAP_BY_NAME.put(timeType.getName(), timeType) != null) {
                throw new RuntimeException("design error: value " + (Object)((Object)timeType) + " duplicated");
            }
            ++n2;
        }
    }

    private TimeType(String name, boolean local) {
        this.name = name;
        this.local = local;
    }

    public String getName() {
        return this.name;
    }

    public boolean isLocal() {
        return this.local;
    }

    public int getLocalOrdinal() {
        if (this.local) {
            return this.ordinal() - MIN_LOCAL_TIME_ORDINAL;
        }
        throw new RuntimeException("illegal call");
    }

    public static TimeType getLocalTimeByItsOrdinal(int localTimeOrdinal) {
        if (localTimeOrdinal >= 0 && localTimeOrdinal < TimeType.values().length - MIN_LOCAL_TIME_ORDINAL) {
            return TimeType.values()[MIN_LOCAL_TIME_ORDINAL + localTimeOrdinal];
        }
        return null;
    }

    public static String[] getLocalTimeTypeNames() {
        String[] names = new String[TimeType.values().length - MIN_LOCAL_TIME_ORDINAL];
        int i = 0;
        while (i < names.length) {
            names[i] = TimeType.getLocalTimeByItsOrdinal(i).getName();
            ++i;
        }
        return names;
    }

    public static TimeType getByName(String name) {
        return MAP_BY_NAME.get(name);
    }
}

