/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.ComplexFloatFFT;
import jnt.FFT.ComplexFloatFFT_Mixed;

public class RealFloat2DFFT_Even {
    int nrows;
    int ncols;
    int rowspan;
    ComplexFloatFFT rowFFT;
    ComplexFloatFFT colFFT;

    public RealFloat2DFFT_Even(int nrows, int ncols) {
        this.nrows = nrows;
        this.ncols = ncols;
        this.rowspan = ncols + 2;
        if (ncols % 2 != 0) {
            throw new Error("The number of columns must be even!");
        }
        this.rowFFT = new ComplexFloatFFT_Mixed(ncols / 2);
        this.colFFT = nrows == ncols / 2 ? this.rowFFT : new ComplexFloatFFT_Mixed(nrows);
    }

    protected void checkData(float[] data, int rowspan) {
        if (rowspan < this.ncols + 2) {
            throw new IllegalArgumentException("The row span " + rowspan + "is not long enough for ncols=" + this.ncols);
        }
        if (this.nrows * rowspan > data.length) {
            throw new IllegalArgumentException("The data array is too small for " + this.nrows + "x" + rowspan + " data.length=" + data.length);
        }
    }

    public void transform(float[] data) {
        this.transform(data, this.ncols + 2);
    }

    public void transform(float[] data, int rowspan) {
        this.checkData(data, rowspan);
        int i = 0;
        while (i < this.nrows) {
            this.rowFFT.transform(data, i * rowspan, 2);
            this.shuffle(data, i * rowspan, 1);
            ++i;
        }
        int nc = this.ncols / 2 + 1;
        int j = 0;
        while (j < nc) {
            this.colFFT.transform(data, 2 * j, rowspan);
            ++j;
        }
    }

    public float[] toWraparoundOrder(float[] data, int rowspan) {
        float[] newdata = new float[2 * this.nrows * this.ncols];
        int nc = this.ncols / 2;
        int i = 0;
        while (i < this.nrows) {
            int i0 = 2 * i * this.ncols;
            int k0 = i * rowspan;
            int r0 = i == 0 ? 0 : (this.nrows - i) * 2 * this.ncols;
            newdata[i0] = data[k0];
            newdata[i0 + 1] = data[k0 + 1];
            newdata[i0 + this.ncols] = data[k0 + this.ncols];
            newdata[i0 + this.ncols + 1] = data[k0 + this.ncols + 1];
            int j = 1;
            while (j < nc) {
                newdata[i0 + 2 * j] = data[k0 + 2 * j];
                newdata[i0 + 2 * j + 1] = data[k0 + 2 * j + 1];
                newdata[r0 + 2 * (this.ncols - j)] = data[k0 + 2 * j];
                newdata[r0 + 2 * (this.ncols - j) + 1] = -data[k0 + 2 * j + 1];
                ++j;
            }
            ++i;
        }
        return newdata;
    }

    public void backtransform(float[] data) {
        this.backtransform(data, this.ncols + 2);
    }

    public void backtransform(float[] data, int rowspan) {
        this.checkData(data, rowspan);
        int nc = this.ncols / 2 + 1;
        int j = 0;
        while (j < nc) {
            this.colFFT.backtransform(data, 2 * j, rowspan);
            ++j;
        }
        int i = 0;
        while (i < this.nrows) {
            this.shuffle(data, i * rowspan, -1);
            this.rowFFT.backtransform(data, i * rowspan, 2);
            ++i;
        }
    }

    private void shuffle(float[] data, int i0, int sign) {
        int nh = this.ncols / 2;
        int nq = this.ncols / 4;
        float c1 = 0.5f;
        float c2 = -0.5f * (float)sign;
        double theta = (double)sign * Math.PI / (double)nh;
        float wtemp = (float)Math.sin(0.5 * theta);
        float wpr = -2.0f * wtemp * wtemp;
        float wpi = (float)(-Math.sin(theta));
        float wr = 1.0f + wpr;
        float wi = wpi;
        int i = 1;
        while (i < nq) {
            int i1 = i0 + 2 * i;
            int i3 = i0 + this.ncols - 2 * i;
            float h1r = c1 * (data[i1] + data[i3]);
            float h1i = c1 * (data[i1 + 1] - data[i3 + 1]);
            float h2r = -c2 * (data[i1 + 1] + data[i3 + 1]);
            float h2i = c2 * (data[i1] - data[i3]);
            data[i1] = h1r + wr * h2r - wi * h2i;
            data[i1 + 1] = h1i + wr * h2i + wi * h2r;
            data[i3] = h1r - wr * h2r + wi * h2i;
            data[i3 + 1] = -h1i + wr * h2i + wi * h2r;
            wtemp = wr;
            wr += wtemp * wpr - wi * wpi;
            wi += wtemp * wpi + wi * wpr;
            ++i;
        }
        float d0 = data[i0];
        if (sign == 1) {
            data[i0] = d0 + data[i0 + 1];
            data[i0 + this.ncols] = d0 - data[i0 + 1];
            data[i0 + 1] = 0.0f;
            data[i0 + this.ncols + 1] = 0.0f;
        } else {
            data[i0] = c1 * (d0 + data[i0 + this.ncols]);
            data[i0 + 1] = c1 * (d0 - data[i0 + this.ncols]);
            data[i0 + this.ncols] = 0.0f;
            data[i0 + this.ncols + 1] = 0.0f;
        }
        if (this.ncols % 4 == 0) {
            int n = i0 + nh + 1;
            data[n] = data[n] * -1.0f;
        }
    }

    public float normalization() {
        return 2.0f / ((float)this.nrows * (float)this.ncols);
    }

    public void inverse(float[] data) {
        this.inverse(data, this.ncols + 2);
    }

    public void inverse(float[] data, int rowspan) {
        this.backtransform(data, rowspan);
        float norm = this.normalization();
        int i = 0;
        while (i < this.nrows) {
            int j = 0;
            while (j < this.ncols) {
                int n = i * rowspan + j;
                data[n] = data[n] * norm;
                ++j;
            }
            ++i;
        }
    }
}

