/*
 * Decompiled with CFR 0.152.
 */
package jnt.FFT;

import jnt.FFT.Factorize;
import jnt.FFT.RealFloatFFT;

public class RealFloatFFT_Radix2
extends RealFloatFFT {
    private int logn;

    public RealFloatFFT_Radix2(int n) {
        super(n);
        this.logn = Factorize.log2(n);
        if (this.logn < 0) {
            throw new IllegalArgumentException(String.valueOf(n) + " is not a power of 2");
        }
    }

    @Override
    public void transform(float[] data, int i0, int stride) {
        this.checkData(data, i0, stride);
        if (this.n == 1) {
            return;
        }
        this.bitreverse(data, i0, stride);
        int p = 1;
        int q = this.n;
        int i = 1;
        while (i <= this.logn) {
            int p_1 = p;
            p *= 2;
            q /= 2;
            int b = 0;
            while (b < q) {
                float t0_real = data[i0 + stride * b * p] + data[i0 + stride * (b * p + p_1)];
                float t1_real = data[i0 + stride * b * p] - data[i0 + stride * (b * p + p_1)];
                data[i0 + stride * b * p] = t0_real;
                data[i0 + stride * (b * p + p_1)] = t1_real;
                ++b;
            }
            float w_real = 1.0f;
            float w_imag = 0.0f;
            double theta = Math.PI * -2 / (double)p;
            float s = (float)Math.sin(theta);
            float t = (float)Math.sin(theta / 2.0);
            float s2 = 2.0f * t * t;
            int a = 1;
            while (a < p_1 / 2) {
                float tmp_real = w_real - s * w_imag - s2 * w_real;
                float tmp_imag = w_imag + s * w_real - s2 * w_imag;
                w_real = tmp_real;
                w_imag = tmp_imag;
                b = 0;
                while (b < q) {
                    float z0_real = data[i0 + stride * (b * p + a)];
                    float z0_imag = data[i0 + stride * (b * p + p_1 - a)];
                    float z1_real = data[i0 + stride * (b * p + p_1 + a)];
                    float z1_imag = data[i0 + stride * (b * p + p - a)];
                    data[i0 + stride * (b * p + a)] = z0_real + w_real * z1_real - w_imag * z1_imag;
                    data[i0 + stride * (b * p + p - a)] = z0_imag + w_real * z1_imag + w_imag * z1_real;
                    data[i0 + stride * (b * p + p_1 - a)] = z0_real - w_real * z1_real + w_imag * z1_imag;
                    data[i0 + stride * (b * p + p_1 + a)] = -(z0_imag - w_real * z1_imag - w_imag * z1_real);
                    ++b;
                }
                ++a;
            }
            if (p_1 > 1) {
                b = 0;
                while (b < q) {
                    int n = i0 + stride * (b * p + p - p_1 / 2);
                    data[n] = data[n] * -1.0f;
                    ++b;
                }
            }
            ++i;
        }
    }

    @Override
    public void backtransform(float[] data, int i0, int stride) {
        this.checkData(data, i0, stride);
        if (this.n == 1) {
            return;
        }
        int p = this.n;
        int q = 1;
        int p_1 = this.n / 2;
        int i = 1;
        while (i <= this.logn) {
            int b = 0;
            while (b < q) {
                float z0 = data[i0 + stride * b * p];
                float z1 = data[i0 + stride * (b * p + p_1)];
                data[i0 + stride * b * p] = z0 + z1;
                data[i0 + stride * (b * p + p_1)] = z0 - z1;
                ++b;
            }
            float w_real = 1.0f;
            float w_imag = 0.0f;
            double theta = Math.PI * 2 / (double)p;
            float s = (float)Math.sin(theta);
            float t = (float)Math.sin(theta / 2.0);
            float s2 = 2.0f * t * t;
            int a = 1;
            while (a < p_1 / 2) {
                float tmp_real = w_real - s * w_imag - s2 * w_real;
                float tmp_imag = w_imag + s * w_real - s2 * w_imag;
                w_real = tmp_real;
                w_imag = tmp_imag;
                b = 0;
                while (b < q) {
                    float z0_real = data[i0 + stride * (b * p + a)];
                    float z0_imag = data[i0 + stride * (b * p + p - a)];
                    float z1_real = data[i0 + stride * (b * p + p_1 - a)];
                    float z1_imag = -data[i0 + stride * (b * p + p_1 + a)];
                    data[i0 + stride * (b * p + a)] = z0_real + z1_real;
                    data[i0 + stride * (b * p + p_1 - a)] = z0_imag + z1_imag;
                    float t1_real = z0_real - z1_real;
                    float t1_imag = z0_imag - z1_imag;
                    data[i0 + stride * (b * p + p_1 + a)] = w_real * t1_real - w_imag * t1_imag;
                    data[i0 + stride * (b * p + p - a)] = w_real * t1_imag + w_imag * t1_real;
                    ++b;
                }
                ++a;
            }
            if (p_1 > 1) {
                b = 0;
                while (b < q) {
                    int n = i0 + stride * (b * p + p_1 / 2);
                    data[n] = data[n] * 2.0f;
                    int n2 = i0 + stride * (b * p + p_1 + p_1 / 2);
                    data[n2] = data[n2] * -2.0f;
                    ++b;
                }
            }
            p_1 /= 2;
            p /= 2;
            q *= 2;
            ++i;
        }
        this.bitreverse(data, i0, stride);
    }

    @Override
    public float[] toWraparoundOrder(float[] data) {
        return this.toWraparoundOrder(data, 0, 1);
    }

    @Override
    public float[] toWraparoundOrder(float[] data, int i0, int stride) {
        this.checkData(data, i0, stride);
        float[] newdata = new float[2 * this.n];
        int nh = this.n / 2;
        newdata[0] = data[i0];
        newdata[1] = 0.0f;
        newdata[this.n] = data[i0 + stride * nh];
        newdata[this.n + 1] = 0.0f;
        int i = 1;
        while (i < nh) {
            newdata[2 * i] = data[i0 + stride * i];
            newdata[2 * i + 1] = data[i0 + stride * (this.n - i)];
            newdata[2 * (this.n - i)] = data[i0 + stride * i];
            newdata[2 * (this.n - i) + 1] = -data[i0 + stride * (this.n - i)];
            ++i;
        }
        return newdata;
    }

    protected void bitreverse(float[] data, int i0, int stride) {
        int i = 0;
        int j = 0;
        while (i < this.n - 1) {
            int k = this.n / 2;
            if (i < j) {
                float tmp = data[i0 + stride * i];
                data[i0 + stride * i] = data[i0 + stride * j];
                data[i0 + stride * j] = tmp;
            }
            while (k <= j) {
                j -= k;
                k /= 2;
            }
            j += k;
            ++i;
        }
    }
}

