/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jca;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.ResourceException;
import org.firebirdsql.jca.FBResourceException;
import org.firebirdsql.jca.FBTpbMapper;

public class FBTpb
implements Serializable {
    private byte[] byteArray = null;
    public static final String TRANSACTION_SERIALIZABLE = "TRANSACTION_SERIALIZABLE";
    public static final String TRANSACTION_REPEATABLE_READ = "TRANSACTION_REPEATABLE_READ";
    public static final String TRANSACTION_READ_COMMITTED = "TRANSACTION_READ_COMMITTED";
    public static final String TRANSACTION_READ_UNCOMMITTED = "TRANSACTION_READ_UNCOMMITTED";
    public static final String TRANSACTION_NONE = "TRANSACTION_NONE";
    public static final Integer ISC_TPB_CONSISTENCY = new Integer(1);
    public static final Integer ISC_TPB_CONCURRENCY = new Integer(2);
    public static final Integer ISC_TPB_READ_COMMITTED = new Integer(15);
    public static final Integer ISC_TPB_REC_VERSION = new Integer(17);
    public static final Integer ISC_TPB_NO_REC_VERSION = new Integer(18);
    public static final Integer ISC_TPB_WAIT = new Integer(6);
    public static final Integer ISC_TPB_NOWAIT = new Integer(7);
    public static final Integer ISC_TPB_READ = new Integer(8);
    public static final Integer ISC_TPB_WRITE = new Integer(9);
    private Set tpb;
    private int txIsolation;
    private boolean readOnly;
    private FBTpbMapper mapper;

    public FBTpb(FBTpb tpb) {
        this.setTpb(tpb);
    }

    public FBTpb(FBTpbMapper mapper) {
        this.mapper = mapper;
        this.txIsolation = 2;
        this.tpb = mapper.getDefaultMapping();
        this.readOnly = false;
        this.createArray();
    }

    public void add(Integer key) {
        if (key == null) {
            throw new IllegalArgumentException("Do not add null to Tpb");
        }
        if (this.tpb.contains(key)) {
            return;
        }
        switch (key) {
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 15: 
            case 17: 
            case 18: {
                this.tpb.add(key);
                break;
            }
            case 8: {
                this.setReadOnly(true);
                break;
            }
            case 9: {
                this.setReadOnly(false);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized Tpb parameter: " + key);
            }
        }
        this.createArray();
    }

    void createArray() {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        Iterator i = this.tpb.iterator();
        while (i.hasNext()) {
            int n = (Integer)i.next();
            bao.write(n);
        }
        this.byteArray = bao.toByteArray();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof FBTpb)) {
            return false;
        }
        return this.tpb.equals(((FBTpb)other).tpb);
    }

    public byte[] getArray() {
        return this.byteArray;
    }

    Set getInternalTpb() {
        return this.tpb;
    }

    public int getIscTransactionIsolation() {
        if (this.tpb.contains(ISC_TPB_CONSISTENCY)) {
            return 1;
        }
        if (this.tpb.contains(ISC_TPB_READ_COMMITTED)) {
            return 15;
        }
        return 2;
    }

    public int getTransactionIsolation() throws ResourceException {
        return this.txIsolation;
    }

    public String getTransactionIsolationName() throws ResourceException {
        switch (this.getTransactionIsolation()) {
            case 8: {
                return TRANSACTION_SERIALIZABLE;
            }
            case 4: {
                return TRANSACTION_REPEATABLE_READ;
            }
            case 2: {
                return TRANSACTION_READ_COMMITTED;
            }
        }
        throw new FBResourceException("Unknown transaction isolation level");
    }

    public int hashCode() {
        return this.tpb.hashCode();
    }

    public boolean isReadOnly() {
        return this.tpb.contains(ISC_TPB_READ);
    }

    /*
     * Exception decompiling
     */
    public void setIscTransactionIsolation(int isolation) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Extractable last case doesn't follow previous, and can't clone.
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.examineSwitchContiguity(SwitchReplacer.java:611)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.SwitchReplacer.replaceRawSwitches(SwitchReplacer.java:94)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:517)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setMapper(FBTpbMapper mapper) {
        this.mapper = mapper;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.tpb.remove(ISC_TPB_READ);
        this.tpb.remove(ISC_TPB_WRITE);
        if (readOnly) {
            this.tpb.add(ISC_TPB_READ);
        } else {
            this.tpb.add(ISC_TPB_WRITE);
        }
        this.createArray();
    }

    public void setTpb(FBTpb tpb) {
        this.tpb = new HashSet(tpb.tpb);
        this.txIsolation = tpb.txIsolation;
        this.mapper = tpb.mapper;
        this.readOnly = tpb.readOnly;
        this.createArray();
    }

    public void setTransactionIsolation(int level) throws ResourceException {
        switch (level) {
            case 2: 
            case 4: 
            case 8: {
                this.tpb = this.mapper.getMapping(level);
                this.txIsolation = level;
                this.setReadOnly(this.readOnly);
                break;
            }
            case 1: {
                this.tpb = this.mapper.getMapping(2);
                this.txIsolation = 2;
                this.setReadOnly(this.readOnly);
                break;
            }
            default: {
                throw new FBResourceException("Unsupported transaction isolation level");
            }
        }
        this.createArray();
    }

    public void setTransactionIsolationName(String tin) throws ResourceException {
        if (TRANSACTION_SERIALIZABLE.equals(tin)) {
            this.setTransactionIsolation(8);
        } else if (TRANSACTION_REPEATABLE_READ.equals(tin)) {
            this.setTransactionIsolation(4);
        } else if (TRANSACTION_READ_COMMITTED.equals(tin)) {
            this.setTransactionIsolation(2);
        } else {
            throw new FBResourceException("Unsupported tx isolation level");
        }
    }
}

