/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.firebirdsql.gds.XSQLVAR;
import org.firebirdsql.jdbc.FBBlob;
import org.firebirdsql.jdbc.FBField;
import org.firebirdsql.jdbc.FBFlushableField;
import org.firebirdsql.jdbc.FBResultSet;
import org.firebirdsql.jdbc.FBSQLException;
import org.firebirdsql.jdbc.FBStringField;

public class FBLongVarCharField
extends FBStringField
implements FBFlushableField {
    private static final int BUFF_SIZE = 4096;
    private boolean isCachedData = false;
    private FBBlob blob;

    FBLongVarCharField(XSQLVAR field, FBResultSet rs, int numCol) throws SQLException {
        super(field, rs, numCol);
    }

    public void close() throws SQLException {
        try {
            try {
                if (this.blob != null) {
                    this.blob.close();
                }
            }
            catch (IOException ioex) {
                throw new FBSQLException(ioex);
            }
            Object var2_2 = null;
            this.blob = null;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.blob = null;
            throw throwable;
        }
    }

    private void copyBinaryStream(InputStream in, int length) throws SQLException {
        if (!this.c.getAutoCommit()) {
            this.c.ensureInTransaction();
        }
        FBBlob blob = new FBBlob(this.c);
        blob.copyStream(in, length);
        this.field.sqldata = XSQLVAR.encodeLong(blob.getBlobId());
    }

    public void flushCachedData() throws SQLException {
        if (this.isCachedData) {
            this.copyBinaryStream(new ByteArrayInputStream(this.field.sqldata), this.field.sqllen);
            this.isCachedData = false;
        }
    }

    InputStream getBinaryStream() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == null) {
            return null;
        }
        return blob.getBinaryStream();
    }

    Blob getBlob() throws SQLException {
        if (this.blob != null) {
            return this.blob;
        }
        if (this.rs.row[this.numCol] == null) {
            return null;
        }
        Long blobId = new Long(XSQLVAR.decodeLong(this.rs.row[this.numCol]));
        this.blob = new FBBlob(this.c, blobId);
        return this.blob;
    }

    byte[] getBytes() throws SQLException {
        Blob blob = this.getBlob();
        if (blob == null) {
            return FBField.BYTES_NULL_VALUE;
        }
        InputStream in = blob.getBinaryStream();
        if (in == null) {
            return FBField.BYTES_NULL_VALUE;
        }
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buff = new byte[4096];
        int counter = 0;
        try {
            try {
                while ((counter = in.read(buff)) != -1) {
                    bout.write(buff, 0, counter);
                }
            }
            catch (IOException ioex) {
                throw (SQLException)FBField.createException(String.valueOf(FBField.BYTES_CONVERSION_ERROR) + " " + ioex.getMessage());
            }
            Object var7_7 = null;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                in.close();
            }
            catch (IOException iOException) {
                throw new SQLException("Unable to close BLOB input stream.");
            }
            try {
                bout.close();
            }
            catch (IOException iOException) {
                throw new SQLException("Unable to close ByteArrayOutputStream.");
            }
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {
            throw new SQLException("Unable to close BLOB input stream.");
        }
        try {
            bout.close();
        }
        catch (IOException iOException) {
            throw new SQLException("Unable to close ByteArrayOutputStream.");
        }
        return bout.toByteArray();
    }

    public byte[] getCachedObject() throws SQLException {
        if (this.rs.row[this.numCol] == null) {
            return FBField.BYTES_NULL_VALUE;
        }
        return this.getBytes();
    }

    Object getObject() throws SQLException {
        return this.getString();
    }

    String getString() throws SQLException {
        byte[] data = this.getBytes();
        if (data == FBField.BYTES_NULL_VALUE) {
            return null;
        }
        return this.field.decodeString(data, this.javaEncoding);
    }

    void setBinaryStream(InputStream in, int length) throws SQLException {
        if (in == null) {
            this.setNull();
            return;
        }
        if (!this.c.getAutoCommit()) {
            this.copyBinaryStream(in, length);
        } else {
            byte[] buff = new byte[4096];
            ByteArrayOutputStream bout = new ByteArrayOutputStream(length);
            try {
                while (length > 0) {
                    int chunk = in.read(buff, 0, length < 4096 ? length : 4096);
                    bout.write(buff, 0, chunk);
                    length -= chunk;
                }
                bout.close();
            }
            catch (IOException ioe) {
                throw new SQLException("read/write blob problem: " + ioe);
            }
            this.field.sqldata = bout.toByteArray();
            this.field.sqllen = this.field.sqldata.length;
            this.isCachedData = true;
        }
    }

    void setBytes(byte[] value) throws SQLException {
        if (value == FBField.BYTES_NULL_VALUE) {
            this.setNull();
            return;
        }
        byte[] data = this.field.encodeString(value, this.javaEncoding);
        this.setBinaryStream(new ByteArrayInputStream(data), data.length);
    }

    void setString(String value) throws SQLException {
        if (value == null) {
            this.setNull();
            return;
        }
        byte[] data = this.field.encodeString(value, this.javaEncoding);
        this.setBinaryStream(new ByteArrayInputStream(data), data.length);
    }
}

