
INSERT INTO Application (Ident,Name) VALUES (1, 'GambitCoefficients_Servlet');
INSERT INTO Application (Ident,Name) VALUES (2, 'TIDExplorer_Backend');
INSERT INTO Application (Ident,Name) VALUES (3, 'GambitExplorer_UserApp');
INSERT INTO Application (Ident,Name) VALUES (4, 'GambitExplorer_MasterApp');
INSERT INTO Application (Ident,Name) VALUES (5, 'Raytrix_ObliqIonoSynth_Servlet');
INSERT INTO Application (Ident,Name) VALUES (6, 'Raytrix_AOA_FF_Servlet');
INSERT INTO Application (Ident,Name) VALUES (7, 'TID_Detector_Servlet');
INSERT INTO Application (Ident,Name) VALUES (8, 'TID_TrackInfo_Servlet');
INSERT INTO Application (Ident,Name) VALUES (9, 'TID_FindTracks_Servlet');
COMMIT;

INSERT INTO UserRole (Ident,Name) VALUES (1, 'Guest');
INSERT INTO UserRole (Ident,Name) VALUES (2, 'User');
INSERT INTO UserRole (Ident,Name) VALUES (3, 'UserRealTime');
INSERT INTO UserRole (Ident,Name) VALUES (4, 'Expert');
INSERT INTO UserRole (Ident,Name) VALUES (5, 'RealTimer');
INSERT INTO UserRole (Ident,Name) VALUES (6, 'SuperExpert');
COMMIT;

/*
Content codes must match Java code. Java apps will test their requested content against this available database content 
*/

INSERT INTO Content (Ident,Name) VALUES ( 0x00001, 'IONO_VI');
INSERT INTO Content (Ident,Name) VALUES ( 0x00002, 'SCALED_VI');
INSERT INTO Content (Ident,Name) VALUES ( 0x00004, 'FASTCHAR_VI');
INSERT INTO Content (Ident,Name) VALUES ( 0x00008, 'DOP_VI');
INSERT INTO Content (Ident,Name) VALUES ( 0x00010, 'DFT_VI');
INSERT INTO Content (Ident,Name) VALUES ( 0x00020, 'SKY_VI');
INSERT INTO Content (Ident,Name) VALUES ( 0x00040, 'DVL_VI');
INSERT INTO Content (Ident,Name) VALUES ( 0x00080, 'TLT_VI');
INSERT INTO Content (Ident,Name) VALUES ( 0x00100, 'DOP_OI');
INSERT INTO Content (Ident,Name) VALUES ( 0x00200, 'SKY_OI');
INSERT INTO Content (Ident,Name) VALUES ( 0x00400, 'TID');
INSERT INTO Content (Ident,Name) VALUES ( 0x00800, 'IONO_OI');
INSERT INTO Content (Ident,Name) VALUES ( 0x01000, 'SCALED_OI');
INSERT INTO Content (Ident,Name) VALUES ( 0x02000, 'TAV');
INSERT INTO Content (Ident,Name) VALUES ( 0x04000, 'IRTAM');
INSERT INTO Content (Ident,Name) VALUES ( 0x08000, 'RPI');
INSERT INTO Content (Ident,Name) VALUES ( 0x10000, 'TNT');

INSERT INTO Database (Ident,DbTitle,Protocol,Host,DbFile,Driver,ContentId) VALUES (1, 'Lowell-DIDB', 'jdbc:firebirdsql', 'didbase.giro.uml.edu', 'didb', 'org.firebirdsql.jdbc.FBDriver', 0x00007);
INSERT INTO Database (Ident,DbTitle,Protocol,Host,DbFile,Driver,ContentId) VALUES (2, 'Lowell-DRIFT', 'jdbc:firebirdsql', 'drift.giro.uml.edu', 'drift', 'org.firebirdsql.jdbc.FBDriver', 0x000F0);
INSERT INTO Database (Ident,DbTitle,Protocol,Host,DbFile,Driver,ContentId) VALUES (3, 'Lowell-GAMBIT', 'jdbc:firebirdsql', 'd2d.giro.uml.edu', 'gambit', 'org.firebirdsql.jdbc.FBDriver', 0x04000);
INSERT INTO Database (Ident,DbTitle,Protocol,Host,DbFile,Driver,ContentId) VALUES (4, 'Lowell-D2D', 'jdbc:firebirdsql', 'd2d.giro.uml.edu', 'd2d', 'org.firebirdsql.jdbc.FBDriver',       0x00100);
INSERT INTO Database (Ident,DbTitle,Protocol,Host,DbFile,Driver,ContentId) VALUES (5, 'Lowell-TAV', 'jdbc:firebirdsql', 'd2d.giro.uml.edu', 'tav', 'org.firebirdsql.jdbc.FBDriver',       0x02000);
INSERT INTO Database (Ident,DbTitle,Protocol,Host,DbFile,Driver,ContentId) VALUES (6, 'Lowell-TID', 'jdbc:firebirdsql', 'tidbase.giro.uml.edu', 'tid', 'org.firebirdsql.jdbc.FBDriver',   0x00400);
INSERT INTO Database (Ident,DbTitle,Protocol,Host,DbFile,Driver,ContentId) VALUES (7, 'Lowell-RPI', 'jdbc:firebirdsql', 'rpi.giro.uml.edu', 'rpi', 'org.firebirdsql.jdbc.FBDriver',       0x08000);
INSERT INTO Database (Ident,DbTitle,Protocol,Host,DbFile,Driver,ContentId) VALUES (8, 'Lowell-TNT', 'jdbc:firebirdsql', 'drtnt.giro.uml.edu', 'tnt', 'org.firebirdsql.jdbc.FBDriver',     0x10000);
INSERT INTO Database (Ident,DbTitle,Protocol,Host,DbFile,Driver,ContentId) VALUES (9, 'Lowell-GAMBIT-M', 'jdbc:mysql', '129.63.134.28', 'GAMBIT', 'com.mysql.cj.jdbc.Driver',             0x04000);
COMMIT;


/* GAMBIT coefficients servlet */
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (1, 1, 3);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (1, 2, 3);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (1, 3, 3);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (1, 1, 9);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (1, 2, 9);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (1, 3, 9);

/* GAMBIT Explorer UserApp */
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (3, 1, 3);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (3, 2, 3);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (3, 3, 3);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (3, 1, 9);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (3, 2, 9);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (3, 3, 9);

/* GAMBIT Explorer MasterApp */
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (4, 4, 3);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (4, 6, 3);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (4, 4, 9);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (4, 6, 9);

/* TIDExplorer_Backend */
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (2, 1, 6);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (2, 2, 6);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (2, 3, 6);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (2, 4, 4);
INSERT INTO ContentUsage (AppId, UserRoleId, DatabaseId) VALUES (2, 4, 6);

/*
INSERT INTO DbCredential (AppId, UserRoleId, DbId, DbUser, DbPass, DbRole) VALUES (1, 1, 3, 'xxx', 'xxx', NULL);
INSERT INTO DbCredential (AppId, UserRoleId, DbId, DbUser, DbPass, DbRole) VALUES (1, 2, 3, 'xxx', 'xxx', NULL);
INSERT INTO DbCredential (AppId, UserRoleId, DbId, DbUser, DbPass, DbRole) VALUES (1, 3, 3, 'xxx', 'xxx', NULL);
*/

/** add some users */
/* one timer */
/* 
 CREATE USER registrar PASSWORD 'blah-blah' FIRSTNAME 'Registrator' LASTNAME '';
 CREATE USER administrator PASSWORD 'blah-blah' FIRSTNAME 'Administrator' LASTNAME '';
**/
COMMIT;
