SELECT c.Name AS "Content", d.DbTitle AS "Title", d.Protocol AS "Protocol", d.Host AS "Host", d.DbFile AS "File",
    dc.DbUser AS "User", dc.DbPass AS "Pass", dc.dbRole AS "Role", d.Driver AS "Driver"
		FROM ContentUsage cu
		JOIN Application a ON cu.AppId=a.Ident
		JOIN UserRole ur ON cu.UserRoleId=ur.Ident
		JOIN Content c ON cu.ContentId=c.Ident
		JOIN ContentLocation cl ON cl.ContentId=cu.ContentId 
		JOIN Database d ON cl.DbId=d.Ident 
		JOIN DbCredential dc ON cu.AppId=dc.AppId AND cu.UserRoleId=dc.UserRoleId AND d.Ident=dc.DbId
		WHERE a.Name='GambitExplorer_MasterApp' AND ur.Name='Expert'
		ORDER BY c.Name