c Computes the Jones and co-authors special functions 
c
c Inputs:
c  la = geographical longitude [0 to 360] (r*8)
c  fi = geographical latitude in degrees (r*8)
c  fm = modip in degrees (r*8)
c
c Output:
c  g(*) = special functions for hmF2 or f0F2 (r*8)
c
c Created by Claudio Brunini.
c
	Subroutine g_fnc(la,fi,fm,g)
      implicit real*8 (a-h,o-z)
      real*8 la,lak,lar
	dimension kfl(9),g(*)
      d2r=datan(1.d0)/45.d0
	data kfl/11,11,8,4,1,0,0,0,0/

	g(1)=1.d0
      sfm=dsin(fm*d2r)
      sfmq=sfm
      do k=1,kfl(1)
	  g(k+1)=sfmq
        sfmq=sfmq*sfm
      enddo

      k=kfl(1)+1
      cf=dcos(fi*d2r)
      cfq=cf
	lar=la*d2r
      do kl=1,8
        lak=dfloat(kl)*lar
        cl=dcos(lak)
        sl=dsin(lak)
        do j=1,kfl(kl+1)+1
          k=k+1
	    g(k)=g(j)*cfq*cl
          k=k+1
	    g(k)=g(j)*cfq*sl
        enddo
        cfq=cfq*cf
      enddo

      return
      end