      Program hmf2_J6
c
c This program computes hmF2 median values for high (R12=100) and low solar activity 
c levels (R12=0) using the special functions developed by Jones and co-authors; 
c and considering a maximum number of harmonics equal to 6 (J=6). 
c 
c It generates a file for each month of the year comprising two data columns; the
c first one is for low solar activity levels, and the second one corresponds to
c periods of high solar activity.
c      
c Output:
c    File containing the F2 peak heights for both low and high solar activity,
c    for each hour of the day and each point of the geographical grid.    
c
c Created by J. Federico Conte, 9/2012.
c 
	implicit real*8(a-h,o-z)
	parameter(ng=73, nx=988, nm=5329)
	real*8 la(ng)
      dimension uf(13,76,2),uh(13,76,2),fi(ng),fm(nm),uh1(nx),uh2(nx)
	dimension g(76)
      character*2 mth
c
c Generates the geographical irregular grid (73 x 73) + modip latitude for each
c point of the grid.
c
	do j=1,ng
	  fi(j)=(dfloat(j-1)+drand(0))*2.5d0-90.d0
	  if(fi(j).gt.90.d0) fi(j)=89.d0
	  la(j)=(dfloat(j-1)+drand(0))*5.0d0
	  if(la(j).gt.360.d0) la(j)=360.d0
	enddo
	l=1
	do i=1,ng
	  y=fi(i)
	  do j=1,ng
	    x=la(j)
	    call modip(x,y,dip)
	    fm(l)=dip
		l=l+1
	  enddo
	enddo
c
c Starts the 12 months loop
c
	do k=1,12
	  write(mth,'(i2.2)') k
	  write(*,*)' Processing for month ',mth
	  write(*,*)
c
c Reads the tabulated coefficients for f0f2 and hmf2
c	  
	  open(11, file='uf_uh.grid.'//mth//'.asc')
	  read(11,2) uf,uh
	  close(11)
c
c Generates the output file
c 
        do ii=1,76
	    do jj=1,13
	      j=jj+13*(ii-1)
	      uh1(j)=uh(jj,ii,1)
	      uh2(j)=uh(jj,ii,2)
	    enddo
	  enddo
c
	  open(13, file='hmf2-J6.'//mth//'.txt')
	  write(13,'(a9,a2)')'% Month: ',mth
	  write(13,'(a35)')'% Rows with data: 127896 (24x73x73)' 
	  write(13,4)'% Column 1: hmf2 values for R12=0  '
	  write(13,4)'% Column 2: hmf2 values for R12=100'
	  write(13,*)
c 
	  l=1
	  do jj=1,24
	    ut=float(jj)
	    jd=1
	    do i=1,ng
	      y=fi(i)
	      do ii=1,ng
		    x=la(ii)
	        z=fm(jd)
	        call g_fnc(x,y,z,g)
c
c Computes hmF2 values for low solar activity (R12 = 0)
c
		    call hmf2(uh1,g,ut,h1)
c
c Computes hmF2 values for high solar activity (R12 = 100)
c
	        call hmf2(uh2,g,ut,h2)
c
c Writes the output file
c
	        write(13,6) h1,h2
	        l=l+1
	        jd=jd+1
	      enddo
	    enddo
	  enddo
	  close(13)
	enddo
c
c Format lines
c
2     format(4e16.8)
4     format(a35)
6     format(f18.13,1x,f18.13)
c
	write(*,*)
	write(*,*)' Program finished'
	write(*,*)
      end
