c Computes hmF2 or f0f2 as a function of UT
c
c Inputs:
c  u(*) = tabulated coefficients comprised in files "uf_uf.grid.##.asc" (r*8)  
c  g(*) = Jones and co-authors special functions for hmf2 or f0f2 (r*8)
c  ut = Universal Time [0 to 24] (r*8)
c
c Output:
c  x = mean hmF2 (or f0f2) value for the corresponding UT (r*8) 
c
	Subroutine hmf2(u,g,ut,x)
      implicit real*8 (a-h,o-z)
	dimension u(*),g(*),kff0(9)
      d2r=datan(1.d0)/45.d0
	data kff0/11,11,8,4,1,0,0,0,0/
      tr=(15.d0*ut-180.d0)*d2r
	x=0.d0

      kg=0
	do kl=1,9
	  do kf=1,kff0(kl)+1 
	    kg=kg+1       
	    x=x+u((kg-1)*13+1)*g(kg)
	    if(kl.gt.1)then
	      kg=kg+1
	      x=x+u((kg-1)*13+1)*g(kg)
	    endif
	  enddo																	 
	enddo

      do jt=1,6
	  w=dfloat(jt)*tr
	  cs=0.d0
	  cc=0.d0
	  kg=0
	  do kl=1,9
	    do kf=1,kff0(kl)+1 
	      kg=kg+1       
	      cs=cs+u((kg-1)*13+2*jt)*g(kg)
	      cc=cc+u((kg-1)*13+2*jt+1)*g(kg)
	      if(kl.gt.1)then
	        kg=kg+1
	        cs=cs+u((kg-1)*13+2*jt)*g(kg)
	        cc=cc+u((kg-1)*13+2*jt+1)*g(kg)
	      endif
	    enddo
	  enddo
	  x=x+cs*dsin(w)+cc*dcos(w)
	enddo
	if(x.lt.0.d0) x=0.001d0

      return
      end		